/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.sampler.SamplerBuffer;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class SamplerBufferAccess {
    private SamplerBufferAccess() {
    }

    @Fold
    public static UnsignedWord getHeaderSize() {
        return UnsignedUtils.roundUp(SizeOf.unsigned(SamplerBuffer.class), WordFactory.unsigned((int)ConfigurationValues.getTarget().wordSize));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void reinitialize(SamplerBuffer buffer) {
        assert (buffer.isNonNull());
        Pointer dataStart = SamplerBufferAccess.getDataStart(buffer);
        buffer.setPos(dataStart);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getDataStart(SamplerBuffer buffer) {
        assert (buffer.isNonNull());
        return ((Pointer)buffer).add(SamplerBufferAccess.getHeaderSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isEmpty(SamplerBuffer buffer) {
        assert (buffer.isNonNull());
        return SamplerBufferAccess.getDataStart(buffer).equal((UnsignedWord)buffer.getPos());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getDataEnd(SamplerBuffer buffer) {
        assert (buffer.isNonNull());
        return SamplerBufferAccess.getDataStart(buffer).add(buffer.getSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean verify(SamplerBuffer buffer) {
        if (buffer.isNull()) {
            return false;
        }
        Pointer start = SamplerBufferAccess.getDataStart(buffer);
        Pointer end = SamplerBufferAccess.getDataEnd(buffer);
        return buffer.getPos().aboveOrEqual((UnsignedWord)start) && buffer.getPos().belowOrEqual((UnsignedWord)end);
    }
}

