/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.CCharPointerHolderImpl;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.jdk.Target_java_nio_DirectByteBuffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.CTypeConversionSupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={CTypeConversionSupport.class})
class CTypeConversionSupportImpl
implements CTypeConversionSupport {
    static final CTypeConversion.CCharPointerHolder NULL_HOLDER = new CTypeConversion.CCharPointerHolder(){

        public CCharPointer get() {
            return (CCharPointer)WordFactory.nullPointer();
        }

        public void close() {
        }
    };

    CTypeConversionSupportImpl() {
    }

    public String toJavaString(CCharPointer cString) {
        if (cString.isNull()) {
            return null;
        }
        return CTypeConversionSupportImpl.toJavaStringUnchecked(cString, SubstrateUtil.strlen(cString));
    }

    public String toJavaString(CCharPointer cString, UnsignedWord length) {
        if (cString.isNull()) {
            return null;
        }
        return CTypeConversionSupportImpl.toJavaStringUnchecked(cString, length);
    }

    public String toJavaString(CCharPointer cString, UnsignedWord length, Charset charset) {
        if (cString.isNull()) {
            return null;
        }
        return CTypeConversionSupportImpl.toJavaStringWithCharset(cString, length, charset);
    }

    public String utf8ToJavaString(CCharPointer utf8String) {
        if (utf8String.isNull()) {
            return null;
        }
        return CTypeConversionSupportImpl.toJavaStringWithCharset(utf8String, SubstrateUtil.strlen(utf8String), StandardCharsets.UTF_8);
    }

    private static String toJavaStringWithCharset(CCharPointer cString, UnsignedWord length, Charset charset) {
        byte[] bytes = new byte[(int)length.rawValue()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = ((Pointer)cString).readByte(i);
        }
        return new String(bytes, charset);
    }

    private static String toJavaStringUnchecked(CCharPointer cString, UnsignedWord length) {
        byte[] bytes = new byte[(int)length.rawValue()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = ((Pointer)cString).readByte(i);
        }
        return new String(bytes);
    }

    public UnsignedWord toCString(CharSequence javaString, CCharPointer buffer, UnsignedWord bufferSize) {
        return this.toCString(javaString, Charset.defaultCharset(), buffer, bufferSize);
    }

    public UnsignedWord toCString(CharSequence javaString, Charset charset, CCharPointer buffer, UnsignedWord bufferSize) {
        if (javaString == null) {
            throw new IllegalArgumentException("Provided Java string is null");
        }
        byte[] baseString = javaString.toString().getBytes(charset);
        long capacity = bufferSize.rawValue();
        if (buffer.isNull()) {
            if (capacity != 0L) {
                throw new IllegalArgumentException("Non zero buffer size passed along with nullptr");
            }
            return WordFactory.unsigned((int)baseString.length);
        }
        if (capacity < (long)(baseString.length + 1)) {
            throw new IllegalArgumentException("Provided buffer is too small to hold 0 terminated java string.");
        }
        for (int i = 0; i < baseString.length; ++i) {
            buffer.write(i, baseString[i]);
        }
        buffer.write(baseString.length, (byte)0);
        return WordFactory.unsigned((int)baseString.length);
    }

    public CTypeConversion.CCharPointerHolder toCString(CharSequence javaString) {
        if (javaString == null) {
            return NULL_HOLDER;
        }
        return new CCharPointerHolderImpl(javaString);
    }

    public CTypeConversion.CCharPointerHolder toCBytes(byte[] bytes) {
        if (bytes == null) {
            return NULL_HOLDER;
        }
        return new CCharPointerHolderImpl(bytes);
    }

    public ByteBuffer asByteBuffer(PointerBase address, int size) {
        ByteBuffer byteBuffer = SubstrateUtil.cast(new Target_java_nio_DirectByteBuffer(address.rawValue(), size), ByteBuffer.class);
        return byteBuffer.order(ConfigurationValues.getTarget().arch.getByteOrder());
    }
}

