/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.hosted.jdk.JNIRegistrationJavaNet;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeJNIAccess;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
@AutomaticallyRegisteredFeature
public class JNIRegistrationJavaNio
extends JNIRegistrationUtil
implements InternalFeature {
    public void duringSetup(Feature.DuringSetupAccess a) {
        JNIRegistrationJavaNio.rerunClassInit((Feature.FeatureAccess)a, "sun.nio.ch.IOUtil", "sun.nio.ch.ServerSocketChannelImpl", "sun.nio.ch.DatagramChannelImpl", "sun.nio.ch.FileChannelImpl", "sun.nio.ch.FileKey");
        JNIRegistrationJavaNio.rerunClassInit((Feature.FeatureAccess)a, "java.nio.file.Files$FileTypeDetectors");
        JNIRegistrationJavaNio.rerunClassInit((Feature.FeatureAccess)a, "sun.nio.ch.Net", "sun.nio.ch.SocketOptionRegistry$LazyInitialization");
        JNIRegistrationJavaNio.rerunClassInit((Feature.FeatureAccess)a, "sun.nio.ch.NativeThread");
        JNIRegistrationJavaNio.rerunClassInit((Feature.FeatureAccess)a, "sun.nio.ch.FileDispatcherImpl", "sun.nio.ch.FileChannelImpl$Unmapper");
        if (JNIRegistrationJavaNio.isPosix()) {
            JNIRegistrationJavaNio.rerunClassInit((Feature.FeatureAccess)a, "sun.nio.ch.SimpleAsynchronousFileChannelImpl", "sun.nio.ch.SimpleAsynchronousFileChannelImpl$DefaultExecutorHolder", "sun.nio.ch.SinkChannelImpl", "sun.nio.ch.SourceChannelImpl");
            JNIRegistrationJavaNio.rerunClassInit((Feature.FeatureAccess)a, "sun.nio.ch.InheritedChannel");
            JNIRegistrationJavaNio.rerunClassInit((Feature.FeatureAccess)a, "sun.nio.fs.UnixNativeDispatcher", "sun.nio.ch.UnixAsynchronousServerSocketChannelImpl");
            if (JNIRegistrationJavaNio.isLinux()) {
                JNIRegistrationJavaNio.rerunClassInit((Feature.FeatureAccess)a, "sun.nio.ch.sctp.SctpChannelImpl");
            }
        } else if (JNIRegistrationJavaNio.isWindows()) {
            JNIRegistrationJavaNio.rerunClassInit((Feature.FeatureAccess)a, "sun.nio.ch.WindowsAsynchronousFileChannelImpl", "sun.nio.ch.WindowsAsynchronousFileChannelImpl$DefaultIocpHolder");
            JNIRegistrationJavaNio.rerunClassInit((Feature.FeatureAccess)a, "sun.nio.fs.WindowsNativeDispatcher", "sun.nio.fs.WindowsSecurity", "sun.nio.ch.Iocp", "sun.nio.ch.WindowsAsynchronousServerSocketChannelImpl", "sun.nio.ch.WindowsAsynchronousSocketChannelImpl");
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        if (JNIRegistrationJavaNio.isPosix()) {
            JNIRegistrationJavaNio.registerForThrowNew((Feature.FeatureAccess)a, "sun.nio.fs.UnixException");
            RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJavaNio.constructor((Feature.FeatureAccess)a, "sun.nio.fs.UnixException", Integer.TYPE)});
        } else if (JNIRegistrationJavaNio.isWindows()) {
            JNIRegistrationJavaNio.registerForThrowNew((Feature.FeatureAccess)a, "sun.nio.fs.WindowsException");
            RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJavaNio.constructor((Feature.FeatureAccess)a, "sun.nio.fs.WindowsException", Integer.TYPE)});
        }
        Consumer<Feature.DuringAnalysisAccess> registerServerSocketChannelImplInitIDs = JNIRegistrationJavaNio::registerServerSocketChannelImplInitIDs;
        if (JavaVersionUtil.JAVA_SPEC <= 11) {
            a.registerReachabilityHandler(registerServerSocketChannelImplInitIDs, new Object[]{JNIRegistrationJavaNio.method((Feature.FeatureAccess)a, "sun.nio.ch.ServerSocketChannelImpl", "initIDs", new Class[0])});
            if (JNIRegistrationJavaNio.isPosix()) {
                a.registerReachabilityHandler(registerServerSocketChannelImplInitIDs, new Object[]{JNIRegistrationJavaNio.method((Feature.FeatureAccess)a, "sun.nio.ch.UnixAsynchronousServerSocketChannelImpl", "initIDs", new Class[0])});
            }
            a.registerReachabilityHandler(JNIRegistrationJavaNio::registerDatagramChannelImplInitIDs, new Object[]{JNIRegistrationJavaNio.method((Feature.FeatureAccess)a, "sun.nio.ch.DatagramChannelImpl", "initIDs", new Class[0])});
        } else {
            a.registerReachabilityHandler(JNIRegistrationJavaNio::registerNetInitIDs, new Object[]{JNIRegistrationJavaNio.method((Feature.FeatureAccess)a, "sun.nio.ch.Net", "initIDs", new Class[0])});
        }
        if (JavaVersionUtil.JAVA_SPEC <= 17) {
            a.registerReachabilityHandler(JNIRegistrationJavaNio::registerFileChannelImplInitIDs, new Object[]{JNIRegistrationJavaNio.method((Feature.FeatureAccess)a, "sun.nio.ch.FileChannelImpl", "initIDs", new Class[0])});
        }
        a.registerReachabilityHandler(JNIRegistrationJavaNio::registerFileKeyInitIDs, new Object[]{JNIRegistrationJavaNio.method((Feature.FeatureAccess)a, "sun.nio.ch.FileKey", "initIDs", new Class[0])});
        if (JNIRegistrationJavaNio.isPosix()) {
            a.registerReachabilityHandler(JNIRegistrationJavaNio::registerUnixNativeDispatcherInit, new Object[]{JNIRegistrationJavaNio.method((Feature.FeatureAccess)a, "sun.nio.fs.UnixNativeDispatcher", "init", new Class[0])});
            if (JNIRegistrationJavaNio.isLinux()) {
                a.registerReachabilityHandler(JNIRegistrationJavaNio::registerSctpChannelImplInitIDs, new Object[]{JNIRegistrationJavaNio.method((Feature.FeatureAccess)a, "sun.nio.ch.sctp.SctpChannelImpl", "initIDs", new Class[0])});
            }
        } else if (JNIRegistrationJavaNio.isWindows()) {
            a.registerReachabilityHandler(JNIRegistrationJavaNio::registerWindowsNativeDispatcherInitIDs, new Object[]{JNIRegistrationJavaNio.method((Feature.FeatureAccess)a, "sun.nio.fs.WindowsNativeDispatcher", "initIDs", new Class[0])});
            a.registerReachabilityHandler(JNIRegistrationJavaNio::registerIocpInitIDs, new Object[]{JNIRegistrationJavaNio.method((Feature.FeatureAccess)a, "sun.nio.ch.Iocp", "initIDs", new Class[0])});
        }
        a.registerReachabilityHandler(JNIRegistrationJavaNio::registerConnectionCreateInetSocketAddress, new Object[]{JNIRegistrationJavaNio.method((Feature.FeatureAccess)a, "com.sun.jndi.ldap.Connection", "createInetSocketAddress", String.class, Integer.TYPE)});
        Consumer<Feature.DuringAnalysisAccess> registerInitInetAddressIDs = JNIRegistrationJavaNet::registerInitInetAddressIDs;
        a.registerReachabilityHandler(registerInitInetAddressIDs, new Object[]{JNIRegistrationJavaNio.method((Feature.FeatureAccess)a, "sun.nio.ch.Net", "initIDs", new Class[0])});
        if (JavaVersionUtil.JAVA_SPEC == 17) {
            RuntimeReflection.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "jdk.internal.access.foreign.MemorySegmentProxy")});
        }
    }

    private static void registerServerSocketChannelImplInitIDs(Feature.DuringAnalysisAccess a) {
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "java.net.InetSocketAddress")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJavaNio.constructor((Feature.FeatureAccess)a, "java.net.InetSocketAddress", InetAddress.class, Integer.TYPE)});
    }

    private static void registerDatagramChannelImplInitIDs(Feature.DuringAnalysisAccess a) {
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "java.net.InetSocketAddress")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJavaNio.constructor((Feature.FeatureAccess)a, "java.net.InetSocketAddress", InetAddress.class, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.ch.DatagramChannelImpl")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.ch.DatagramChannelImpl", "sender", "cachedSenderInetAddress", "cachedSenderPort"));
    }

    private static void registerNetInitIDs(Feature.DuringAnalysisAccess a) {
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "java.net.InetSocketAddress")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJavaNio.constructor((Feature.FeatureAccess)a, "java.net.InetSocketAddress", InetAddress.class, Integer.TYPE)});
    }

    private static void registerFileChannelImplInitIDs(Feature.DuringAnalysisAccess a) {
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.ch.FileChannelImpl", "fd"));
    }

    private static void registerFileKeyInitIDs(Feature.DuringAnalysisAccess a) {
        if (JNIRegistrationJavaNio.isPosix()) {
            RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.ch.FileKey", "st_dev", "st_ino"));
        } else if (JNIRegistrationJavaNio.isWindows()) {
            RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.ch.FileKey", "dwVolumeSerialNumber", "nFileIndexHigh", "nFileIndexLow"));
        }
    }

    private static void registerUnixNativeDispatcherInit(Feature.DuringAnalysisAccess a) {
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.fs.UnixFileAttributes")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.fs.UnixFileAttributes", "st_mode", "st_ino", "st_dev", "st_rdev", "st_nlink", "st_uid", "st_gid", "st_size", "st_atime_sec", "st_atime_nsec", "st_mtime_sec", "st_mtime_nsec", "st_ctime_sec", "st_ctime_nsec"));
        Field unixCreationTimeField = ReflectionUtil.lookupField((boolean)true, JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.fs.UnixFileAttributes"), (String)"st_birthtime_nsec");
        if (JNIRegistrationJavaNio.isDarwin() || unixCreationTimeField != null) {
            RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.fs.UnixFileAttributes", "st_birthtime_sec"));
        }
        if (unixCreationTimeField != null) {
            RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.fs.UnixFileAttributes", "st_birthtime_nsec"));
        }
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.fs.UnixFileStoreAttributes")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.fs.UnixFileStoreAttributes", "f_frsize", "f_blocks", "f_bfree", "f_bavail"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.fs.UnixMountEntry")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.fs.UnixMountEntry", "name", "dir", "fstype", "opts", "dev"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.fs.UnixMountEntry")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.fs.UnixMountEntry", "name", "dir", "fstype", "opts"));
    }

    private static void registerSctpChannelImplInitIDs(Feature.DuringAnalysisAccess a) {
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.ch.sctp.MessageInfoImpl")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJavaNio.constructor((Feature.FeatureAccess)a, "sun.nio.ch.sctp.MessageInfoImpl", Integer.TYPE, SocketAddress.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.ch.sctp.ResultContainer")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.ch.sctp.ResultContainer", "value", "type"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.ch.sctp.SendFailed")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJavaNio.constructor((Feature.FeatureAccess)a, "sun.nio.ch.sctp.SendFailed", Integer.TYPE, SocketAddress.class, ByteBuffer.class, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.ch.sctp.AssociationChange")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJavaNio.constructor((Feature.FeatureAccess)a, "sun.nio.ch.sctp.AssociationChange", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.ch.sctp.PeerAddrChange")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJavaNio.constructor((Feature.FeatureAccess)a, "sun.nio.ch.sctp.PeerAddrChange", Integer.TYPE, SocketAddress.class, Integer.TYPE)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.ch.sctp.Shutdown")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJavaNio.constructor((Feature.FeatureAccess)a, "sun.nio.ch.sctp.Shutdown", Integer.TYPE)});
    }

    private static void registerWindowsNativeDispatcherInitIDs(Feature.DuringAnalysisAccess a) {
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.fs.WindowsNativeDispatcher$FirstFile")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.fs.WindowsNativeDispatcher$FirstFile", "handle", "name", "attributes"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.fs.WindowsNativeDispatcher$FirstStream")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.fs.WindowsNativeDispatcher$FirstStream", "handle", "name"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.fs.WindowsNativeDispatcher$VolumeInformation")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.fs.WindowsNativeDispatcher$VolumeInformation", "fileSystemName", "volumeName", "volumeSerialNumber", "flags"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.fs.WindowsNativeDispatcher$DiskFreeSpace")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.fs.WindowsNativeDispatcher$DiskFreeSpace", "freeBytesAvailable", "totalNumberOfBytes", "totalNumberOfFreeBytes"));
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.fs.WindowsNativeDispatcher$DiskFreeSpace", "bytesPerSector"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.fs.WindowsNativeDispatcher$Account")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.fs.WindowsNativeDispatcher$Account", "domain", "name", "use"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.fs.WindowsNativeDispatcher$AclInformation")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.fs.WindowsNativeDispatcher$AclInformation", "aceCount"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.fs.WindowsNativeDispatcher$CompletionStatus")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.fs.WindowsNativeDispatcher$CompletionStatus", "error", "bytesTransferred", "completionKey"));
    }

    private static void registerIocpInitIDs(Feature.DuringAnalysisAccess a) {
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "sun.nio.ch.Iocp$CompletionStatus")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJavaNio.fields((Feature.FeatureAccess)a, "sun.nio.ch.Iocp$CompletionStatus", "error", "bytesTransferred", "completionKey", "overlapped"));
    }

    private static void registerConnectionCreateInetSocketAddress(Feature.DuringAnalysisAccess a) {
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationJavaNio.clazz((Feature.FeatureAccess)a, "java.net.InetSocketAddress")});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationJavaNio.constructor((Feature.FeatureAccess)a, "java.net.InetSocketAddress", InetAddress.class, Integer.TYPE)});
    }
}

