/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.objectfile.BasicProgbitsSectionImpl;
import com.oracle.objectfile.ElementImpl;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.objectfile.io.AssemblyBuffer;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.UniqueShortNameProvider;
import com.oracle.svm.core.UniqueShortNameProviderDefaultImpl;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.image.NativeImageBFDNameProvider;
import com.oracle.svm.hosted.image.NativeImageDebugInfoProvider;
import com.oracle.svm.hosted.image.sources.SourceManager;
import com.oracle.svm.hosted.util.DiagnosticUtils;
import java.nio.ByteOrder;
import java.util.List;
import java.util.function.Function;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class NativeImageDebugInfoFeature
implements InternalFeature {
    NativeImageDebugInfoFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.useDebugInfoGeneration();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (!UniqueShortNameProviderDefaultImpl.UseDefault.useDefaultProvider() && !ImageSingletons.contains(UniqueShortNameProvider.class)) {
            FeatureImpl.AfterRegistrationAccessImpl accessImpl = (FeatureImpl.AfterRegistrationAccessImpl)access;
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            ClassLoader appLoader = accessImpl.getApplicationClassLoader();
            ClassLoader imageLoader = accessImpl.getImageClassLoader().getClassLoader();
            ClassLoader imageLoaderParent = imageLoader.getParent();
            assert (imageLoaderParent == appLoader.getParent());
            List<ClassLoader> ignored = List.of(systemLoader, imageLoaderParent, appLoader, imageLoader);
            ImageSingletons.add(UniqueShortNameProvider.class, (Object)new NativeImageBFDNameProvider(ignored));
        }
    }

    public void beforeImageWrite(Feature.BeforeImageWriteAccess access) {
        Timer timer = TimerCollection.singleton().get(TimerCollection.Registry.DEBUG_INFO);
        try (Timer.StopTimer t = timer.start();){
            ImageSingletons.add(SourceManager.class, (Object)new SourceManager());
            FeatureImpl.BeforeImageWriteAccessImpl accessImpl = (FeatureImpl.BeforeImageWriteAccessImpl)access;
            AbstractImage image = accessImpl.getImage();
            DebugContext debugContext = new DebugContext.Builder(HostedOptionValues.singleton(), (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalAccess.getOriginalSnippetReflection())).build();
            NativeImageDebugInfoProvider provider = new NativeImageDebugInfoProvider(debugContext, image.getCodeCache(), image.getHeap(), accessImpl.getHostedMetaAccess());
            ObjectFile objectFile = image.getObjectFile();
            objectFile.installDebugInfo((DebugInfoProvider)provider);
            if (Platform.includedIn(Platform.LINUX.class) && SubstrateOptions.UseImagebuildDebugSections.getValue().booleanValue()) {
                Function<List, BasicProgbitsSectionImpl> makeSectionImpl = customInfo -> {
                    AssemblyBuffer content = AssemblyBuffer.createOutputAssembler((ByteOrder)objectFile.getByteOrder());
                    for (String elem : customInfo) {
                        content.writeString(elem);
                    }
                    return new BasicProgbitsSectionImpl(content.getBlob()){

                        public boolean isLoadable() {
                            return false;
                        }
                    };
                };
                ImageClassLoader imageClassLoader = accessImpl.getImageClassLoader();
                objectFile.newUserDefinedSection(".debug.svm.imagebuild.classpath", (ElementImpl)makeSectionImpl.apply(DiagnosticUtils.getClassPath(imageClassLoader)));
                objectFile.newUserDefinedSection(".debug.svm.imagebuild.modulepath", (ElementImpl)makeSectionImpl.apply(DiagnosticUtils.getModulePath(imageClassLoader)));
                objectFile.newUserDefinedSection(".debug.svm.imagebuild.arguments", (ElementImpl)makeSectionImpl.apply(DiagnosticUtils.getBuilderArguments(imageClassLoader)));
                objectFile.newUserDefinedSection(".debug.svm.imagebuild.java.properties", (ElementImpl)makeSectionImpl.apply(DiagnosticUtils.getBuilderProperties()));
            }
        }
        ProgressReporter.singleton().setDebugInfoTimer(timer);
    }
}

