/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.code.BytecodePosition;

public class AnalysisMethodCalleeWalker {
    private final List<AnalysisMethod> path = new ArrayList<AnalysisMethod>();

    public boolean walkMethod(AnalysisMethod method, CallPathVisitor visitor) {
        if (visitor.prologue() != CallPathVisitor.VisitResult.CONTINUE) {
            return false;
        }
        this.path.clear();
        this.walkMethodAndCallees(method, null, null, visitor);
        CallPathVisitor.VisitResult epilogueResult = visitor.epilogue();
        return epilogueResult != CallPathVisitor.VisitResult.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CallPathVisitor.VisitResult walkMethodAndCallees(AnalysisMethod method, AnalysisMethod caller, BytecodePosition invokePosition, CallPathVisitor visitor) {
        if (this.path.contains(method)) {
            return CallPathVisitor.VisitResult.CUT;
        }
        this.path.add(method);
        try {
            CallPathVisitor.VisitResult directResult = visitor.visitMethod(method, caller, invokePosition, this.path.size());
            if (directResult != CallPathVisitor.VisitResult.CONTINUE) {
                CallPathVisitor.VisitResult visitResult = directResult;
                return visitResult;
            }
            for (InvokeInfo invoke : method.getInvokes()) {
                this.walkMethodAndCallees(invoke.getTargetMethod(), method, invoke.getPosition(), visitor);
            }
            if (caller != null) {
                for (AnalysisMethod impl : method.getImplementations()) {
                    this.walkMethodAndCallees(impl, caller, invokePosition, visitor);
                }
            }
            AnalysisMethod[] analysisMethodArray = CallPathVisitor.VisitResult.CONTINUE;
            return analysisMethodArray;
        }
        finally {
            this.path.remove(method);
        }
    }

    static abstract class CallPathVisitor {
        CallPathVisitor() {
        }

        public VisitResult prologue() {
            return VisitResult.CONTINUE;
        }

        public abstract VisitResult visitMethod(AnalysisMethod var1, AnalysisMethod var2, BytecodePosition var3, int var4);

        public VisitResult epilogue() {
            return VisitResult.CONTINUE;
        }

        public static enum VisitResult {
            CONTINUE,
            CUT,
            QUIT;

        }
    }
}

