/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.svm.core.graal.thread.VMThreadLocalAccess;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.classinitialization.ClassInitializerHasSideEffectsException;
import com.oracle.svm.hosted.classinitialization.ProvenSafeClassInitializationSupport;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeList;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.UnsafeAccessNode;
import org.graalvm.compiler.nodes.java.AccessFieldNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewMultiArrayNode;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

final class AbortOnDisallowedNode
extends Graph.NodeEventListener {
    AbortOnDisallowedNode() {
    }

    public void nodeAdded(Node node) {
        if (node instanceof Invoke) {
            throw new ClassInitializerHasSideEffectsException("Non-inlined invoke of method: " + ((Invoke)node).getTargetMethod().format("%H.%n(%p)"));
        }
        if (node instanceof AccessFieldNode) {
            ResolvedJavaField field = ((AccessFieldNode)node).field();
            ResolvedJavaMethod clinit = ((StructuredGraph)node.graph()).method();
            if (field.isStatic() && !field.getDeclaringClass().equals(clinit.getDeclaringClass())) {
                throw new ClassInitializerHasSideEffectsException("Access of static field from a different class: " + field.format("%H.%n"));
            }
        } else {
            if (node instanceof VMThreadLocalAccess) {
                throw new ClassInitializerHasSideEffectsException("Access of thread-local value");
            }
            if (node instanceof UnsafeAccessNode) {
                throw VMError.shouldNotReachHere("Intrinsification of Unsafe methods is not enabled during bytecode parsing");
            }
            if (node instanceof NewArrayNode) {
                AbortOnDisallowedNode.checkArrayAllocationLength(((NewArrayNode)node).length());
            } else if (node instanceof NewMultiArrayNode) {
                NodeList dimensions = ((NewMultiArrayNode)node).dimensions();
                for (ValueNode dimension : dimensions) {
                    AbortOnDisallowedNode.checkArrayAllocationLength(dimension);
                }
            }
        }
    }

    private static void checkArrayAllocationLength(ValueNode lengthNode) {
        int length;
        JavaConstant lengthConstant = lengthNode.asJavaConstant();
        if (lengthConstant != null && ((length = lengthConstant.asInt()) < 0 || length > 100000)) {
            Class clazz = OriginalClassProvider.getJavaClass((ResolvedJavaType)lengthNode.graph().method().getDeclaringClass());
            ((ProvenSafeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).mustNotBeProvenSafe.add(clazz);
            throw new ClassInitializerHasSideEffectsException("Allocation of too large array in class initializer");
        }
    }
}

