/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.ameta;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.UninitializedStaticFieldValueReader;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.meta.HostedField;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

public interface ReadableJavaField
extends ResolvedJavaField {
    public static JavaConstant readFieldValue(MetaAccessProvider metaAccess, ClassInitializationSupport classInitializationSupport, ResolvedJavaField field, JavaConstant receiver) {
        if (!1.$assertionsDisabled && (field instanceof AnalysisField || field instanceof HostedField)) {
            throw new AssertionError((Object)"must have been unwrapped");
        }
        if (field instanceof ReadableJavaField) {
            ReadableJavaField readableField = (ReadableJavaField)field;
            if (!1.$assertionsDisabled && !readableField.isValueAvailable()) {
                throw new AssertionError((Object)("Field " + readableField.format("%H.%n") + " value not available for reading."));
            }
            return readableField.readValue(metaAccess, classInitializationSupport, receiver);
        }
        if (classInitializationSupport.shouldInitializeAtRuntime(field.getDeclaringClass())) {
            if (field.isStatic()) {
                return UninitializedStaticFieldValueReader.readUninitializedStaticValue((ResolvedJavaField)field, value -> GraalAccess.getOriginalSnippetReflection().forObject(value));
            }
            throw VMError.shouldNotReachHere("Cannot read instance field of a class that is initialized at run time: " + field.format("%H.%n"));
        }
        return GraalAccess.getOriginalProviders().getConstantReflection().readFieldValue(field, receiver);
    }

    public JavaConstant readValue(MetaAccessProvider var1, ClassInitializationSupport var2, JavaConstant var3);

    public boolean isValueAvailableBeforeAnalysis();

    default public boolean isValueAvailable() {
        return this.isValueAvailableBeforeAnalysis() || BuildPhaseProvider.isAnalysisFinished();
    }

    public boolean injectFinalForRuntimeCompilation();

    public static boolean injectFinalForRuntimeCompilation(ResolvedJavaField original) {
        if (original instanceof ReadableJavaField) {
            return ((ReadableJavaField)original).injectFinalForRuntimeCompilation();
        }
        return false;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

