/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.amd64.AMD64CPUFeatureAccess;
import com.oracle.svm.core.amd64.AMD64LibCHelper;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.CPUFeatureAccessFeatureBase;
import com.oracle.svm.hosted.FeatureImpl;
import java.util.EnumSet;
import jdk.vm.ci.amd64.AMD64;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={Platform.AMD64.class})
public class AMD64CPUFeatureAccessFeature
extends CPUFeatureAccessFeatureBase
implements InternalFeature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess arg) {
        SubstrateTargetDescription targetDescription = (SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class));
        AMD64 arch = (AMD64)targetDescription.arch;
        EnumSet<AMD64.CPUFeature> buildtimeCPUFeatures = AMD64CPUFeatureAccessFeature.filterFeatures(arch.getFeatures());
        this.initializeCPUFeatureAccessData((Enum<T>[])AMD64.CPUFeature.values(), buildtimeCPUFeatures, AMD64LibCHelper.CPUFeatures.class, (FeatureImpl.BeforeAnalysisAccessImpl)arg);
    }

    @Override
    protected AMD64CPUFeatureAccess createCPUFeatureAccessSingleton(EnumSet<?> buildtimeCPUFeatures, int[] offsets, byte[] errorMessageBytes, byte[] buildtimeFeatureMaskBytes) {
        return new AMD64CPUFeatureAccess(buildtimeCPUFeatures, offsets, errorMessageBytes, buildtimeFeatureMaskBytes);
    }

    private static EnumSet<AMD64.CPUFeature> filterFeatures(EnumSet<AMD64.CPUFeature> features) {
        EnumSet<AMD64.CPUFeature> ret = EnumSet.copyOf(features);
        ret.remove(AMD64.CPUFeature.HT);
        return ret;
    }
}

