/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.os.MemoryProtectionProvider;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.SubstrateGraalUtils;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerIsolateThread;
import com.oracle.svm.graal.isolated.ImageHeapObjects;
import com.oracle.svm.graal.isolated.ImageHeapRef;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.svm.graal.isolated.IsolatedRuntimeCodeInstaller;
import com.oracle.svm.graal.isolated.OptionValuesEncoder;
import com.oracle.svm.graal.meta.SubstrateMethod;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import jdk.vm.ci.code.InstalledCode;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.options.OptionsParser;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Isolates;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.VMRuntime;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class IsolatedGraalUtils {
    public static CompilerIsolateThread createCompilationIsolate() {
        Isolates.CreateIsolateParameters.Builder builder = new Isolates.CreateIsolateParameters.Builder();
        long addressSpaceSize = SubstrateOptions.CompilationIsolateAddressSpaceSize.getValue();
        if (addressSpaceSize > 0L) {
            builder.reservedAddressSpaceSize((UnsignedWord)WordFactory.signed((long)addressSpaceSize));
        }
        if (MemoryProtectionProvider.isAvailable()) {
            Isolates.ProtectionDomain domain = MemoryProtectionProvider.singleton().getProtectionDomain();
            builder.setProtectionDomain(domain);
        }
        builder.appendArgument(IsolatedGraalUtils.getOptionString(SubstrateOptions.ConcealedOptions.AutomaticReferenceHandling, false));
        Isolates.CreateIsolateParameters params = builder.build();
        CompilerIsolateThread isolate = (CompilerIsolateThread)Isolates.createIsolate((Isolates.CreateIsolateParameters)params);
        IsolatedGraalUtils.initializeCompilationIsolate(isolate);
        return isolate;
    }

    private static void initializeCompilationIsolate(CompilerIsolateThread isolate) {
        byte[] encodedOptions = IsolatedGraalUtils.encodeRuntimeOptionValues();
        try (PinnedObject pin = PinnedObject.create((Object)encodedOptions);){
            IsolatedGraalUtils.initializeCompilationIsolate0(isolate, pin.addressOfArrayElement(0), encodedOptions.length);
        }
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void initializeCompilationIsolate0(@CEntryPoint.IsolateThreadContext CompilerIsolateThread isolate, PointerBase runtimeOptions, int runtimeOptionsLength) {
        IsolatedGraalUtils.applyClientRuntimeOptionValues(runtimeOptions, runtimeOptionsLength);
        VMRuntime.initialize();
    }

    public static InstalledCode compileInNewIsolateAndInstall(SubstrateMethod method) {
        CompilerIsolateThread context = IsolatedGraalUtils.createCompilationIsolate();
        IsolatedCompileClient.set(new IsolatedCompileClient(context));
        ClientHandle<SubstrateInstalledCode> installedCodeHandle = IsolatedGraalUtils.compileInNewIsolateAndInstall0(context, (ClientIsolateThread)CurrentIsolate.getCurrentThread(), ImageHeapObjects.ref(method));
        Isolates.tearDownIsolate((IsolateThread)context);
        InstalledCode installedCode = (InstalledCode)IsolatedCompileClient.get().unhand(installedCodeHandle);
        IsolatedCompileClient.set(null);
        return installedCode;
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static ClientHandle<SubstrateInstalledCode> compileInNewIsolateAndInstall0(@CEntryPoint.IsolateThreadContext CompilerIsolateThread isolate, ClientIsolateThread clientIsolate, ImageHeapRef<SubstrateMethod> methodRef) {
        IsolatedCompileContext.set(new IsolatedCompileContext(clientIsolate));
        SubstrateMethod method = ImageHeapObjects.deref(methodRef);
        DebugContext debug = new DebugContext.Builder((OptionValues)RuntimeOptionValues.singleton(), (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalSupport.getRuntimeConfig().getSnippetReflection())).build();
        CompilationResult compilationResult = SubstrateGraalUtils.doCompile(debug, GraalSupport.getRuntimeConfig(), GraalSupport.getLIRSuites(), method);
        ClientHandle<SubstrateInstalledCode> installedCodeHandle = IsolatedRuntimeCodeInstaller.installInClientIsolate(methodRef, compilationResult, (ClientHandle)IsolatedHandles.nullHandle());
        Log.log().string("Code for " + method.format("%H.%n(%p)") + ": " + compilationResult.getTargetCodeSize() + " bytes").newline();
        IsolatedCompileContext.set(null);
        return installedCodeHandle;
    }

    public static void compileInNewIsolate(SubstrateMethod method) {
        if (SubstrateOptions.shouldCompileInIsolates()) {
            CompilerIsolateThread context = IsolatedGraalUtils.createCompilationIsolate();
            IsolatedCompileClient.set(new IsolatedCompileClient(context));
            IsolatedGraalUtils.compileInNewIsolate0(context, (ClientIsolateThread)CurrentIsolate.getCurrentThread(), ImageHeapObjects.ref(method));
            Isolates.tearDownIsolate((IsolateThread)context);
            IsolatedCompileClient.set(null);
        } else {
            try (DebugContext debug = new DebugContext.Builder((OptionValues)RuntimeOptionValues.singleton(), (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalSupport.getRuntimeConfig().getSnippetReflection())).build();){
                SubstrateGraalUtils.compile(debug, method);
            }
        }
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void compileInNewIsolate0(@CEntryPoint.IsolateThreadContext CompilerIsolateThread isolate, ClientIsolateThread clientIsolate, ImageHeapRef<SubstrateMethod> methodRef) {
        IsolatedCompileContext.set(new IsolatedCompileContext(clientIsolate));
        try (DebugContext debug = new DebugContext.Builder((OptionValues)RuntimeOptionValues.singleton(), (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalSupport.getRuntimeConfig().getSnippetReflection())).build();){
            SubstrateGraalUtils.doCompile(debug, GraalSupport.getRuntimeConfig(), GraalSupport.getLIRSuites(), ImageHeapObjects.deref(methodRef));
        }
        IsolatedCompileContext.set(null);
    }

    public static byte[] encodeRuntimeOptionValues() {
        EconomicMap result = EconomicMap.create();
        UnmodifiableMapCursor cur = RuntimeOptionValues.singleton().getMap().getEntries();
        while (cur.advance()) {
            OptionKey optionKey = (OptionKey)cur.getKey();
            if (!IsolatedGraalUtils.shouldCopyToCompilationIsolate(optionKey)) continue;
            result.put((Object)optionKey, cur.getValue());
        }
        result.put((Object)DebugOptions.DumpPath, (Object)DebugOptions.getDumpDirectoryName((OptionValues)RuntimeOptionValues.singleton()));
        return OptionValuesEncoder.encode(result);
    }

    private static boolean shouldCopyToCompilationIsolate(OptionKey<?> optionKey) {
        if (optionKey instanceof RuntimeOptionKey) {
            return ((RuntimeOptionKey)optionKey).shouldCopyToCompilationIsolate();
        }
        return true;
    }

    public static int getNullableArrayLength(Object array) {
        return array != null ? Array.getLength(array) : -1;
    }

    public static void applyClientRuntimeOptionValues(PointerBase encodedOptionsPtr, int encodedOptionsLength) {
        if (encodedOptionsPtr.isNull()) {
            return;
        }
        byte[] encodedOptions = new byte[encodedOptionsLength];
        ByteBuffer buffer = CTypeConversion.asByteBuffer((PointerBase)encodedOptionsPtr, (int)encodedOptionsLength);
        buffer.get(encodedOptions);
        EconomicMap<OptionKey<?>, Object> options = OptionValuesEncoder.decode(encodedOptions);
        options.replaceAll((k, v) -> OptionsParser.parseOptionValue((OptionDescriptor)k.getDescriptor(), (Object)v));
        RuntimeOptionValues.singleton().update((UnmodifiableEconomicMap)options);
    }

    private static String getOptionString(RuntimeOptionKey<Boolean> option, boolean value) {
        return "-XX:" + (value ? "+" : "-") + option.getName();
    }

    private IsolatedGraalUtils() {
    }
}

