/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.os.AbstractCopyingImageHeapProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.windows.WindowsUtils;
import com.oracle.svm.core.windows.headers.FileAPI;
import com.oracle.svm.core.windows.headers.LibLoaderAPI;
import com.oracle.svm.core.windows.headers.MemoryAPI;
import com.oracle.svm.core.windows.headers.WinBase;
import com.oracle.svm.core.windows.headers.WindowsLibC;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class WindowsImageHeapProvider
extends AbstractCopyingImageHeapProvider {
    private static final CGlobalData<PointerBase> IMAGE_BASE = CGlobalDataFactory.forSymbol("__ImageBase");
    private static final CGlobalData<WordPointer> IMAGE_HEAP_FILE_MAPPING = CGlobalDataFactory.createWord((WordBase)WindowsUtils.UNINITIALIZED_HANDLE);
    private static final CGlobalData<WordPointer> IMAGE_HEAP_FILE_OFFSET = CGlobalDataFactory.createWord();
    private static final CGlobalData<CCharPointer> NTDLL_DLL = CGlobalDataFactory.createCString("ntdll.dll");
    private static final CGlobalData<CCharPointer> RTL_IMAGE_NT_HEADER = CGlobalDataFactory.createCString("RtlImageNtHeader");
    private static final CGlobalData<CCharPointer> RTL_ADDRESS_IN_SECTION_TABLE = CGlobalDataFactory.createCString("RtlAddressInSectionTable");
    private static final int ERROR_BAD_EXE_FORMAT = 193;

    @Override
    @Uninterruptible(reason="Called during isolate initialization.")
    protected int commitAndCopyMemory(Pointer loadedImageHeap, UnsignedWord imageHeapSize, Pointer newImageHeap) {
        WinBase.HANDLE imageHeapFileMapping = WindowsImageHeapProvider.getImageHeapFileMapping();
        if (imageHeapFileMapping.isNull()) {
            return super.commitAndCopyMemory(loadedImageHeap, imageHeapSize, newImageHeap);
        }
        if (VirtualMemoryProvider.get().mapFile((PointerBase)newImageHeap, imageHeapSize, (WordBase)imageHeapFileMapping, WindowsImageHeapProvider.getImageHeapFileOffset(), 3).isNull()) {
            return super.commitAndCopyMemory(loadedImageHeap, imageHeapSize, newImageHeap);
        }
        return this.copyMemory((Pointer)Isolates.IMAGE_HEAP_RELOCATABLE_BEGIN.get(), (UnsignedWord)Isolates.IMAGE_HEAP_RELOCATABLE_END.get().subtract(Isolates.IMAGE_HEAP_RELOCATABLE_BEGIN.get()), newImageHeap.add((UnsignedWord)Isolates.IMAGE_HEAP_RELOCATABLE_BEGIN.get().subtract(Isolates.IMAGE_HEAP_BEGIN.get())));
    }

    @Override
    @Uninterruptible(reason="Called during isolate initialization.")
    protected int copyMemory(Pointer loadedImageHeap, UnsignedWord imageHeapSize, Pointer newImageHeap) {
        LibC.memcpy(newImageHeap, (PointerBase)loadedImageHeap, imageHeapSize);
        return 0;
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    private static WinBase.HANDLE getImageHeapFileMapping() {
        WinBase.HANDLE value = (WinBase.HANDLE)IMAGE_HEAP_FILE_MAPPING.get().read();
        if (value.equal((ComparableWord)WindowsUtils.UNINITIALIZED_HANDLE)) {
            WinBase.HANDLE fileMapping = WindowsImageHeapProvider.createImageHeapFileMapping();
            WinBase.HANDLE existingMapping = (WinBase.HANDLE)((Pointer)IMAGE_HEAP_FILE_MAPPING.get()).compareAndSwapWord(0, (WordBase)WindowsUtils.UNINITIALIZED_HANDLE, (WordBase)fileMapping, LocationIdentity.ANY_LOCATION);
            if (existingMapping.equal((ComparableWord)WindowsUtils.UNINITIALIZED_HANDLE)) {
                value = fileMapping;
            } else {
                value = existingMapping;
                WinBase.CloseHandle(fileMapping);
            }
        }
        return value;
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    private static WinBase.HANDLE createImageHeapFileMapping() {
        WindowsLibC.WCharPointer filePath = (WindowsLibC.WCharPointer)StackValue.get((int)260, WindowsLibC.WCharPointer.class);
        int length = LibLoaderAPI.GetModuleFileNameW((WinBase.HMODULE)IMAGE_BASE.get(), filePath, 260);
        if (length == 0 || length == 260) {
            return (WinBase.HANDLE)WordFactory.nullPointer();
        }
        WinBase.HANDLE fileHandle = FileAPI.CreateFileW(filePath, FileAPI.GENERIC_READ(), FileAPI.FILE_SHARE_READ() | FileAPI.FILE_SHARE_DELETE(), WordFactory.nullPointer(), FileAPI.OPEN_EXISTING(), 0, (WinBase.HANDLE)WordFactory.nullPointer());
        if (fileHandle.equal((ComparableWord)WinBase.INVALID_HANDLE_VALUE())) {
            return (WinBase.HANDLE)WordFactory.nullPointer();
        }
        WinBase.HANDLE fileMapping = MemoryAPI.CreateFileMappingW(fileHandle, WordFactory.nullPointer(), MemoryAPI.PAGE_READONLY(), 0, 0, (WindowsLibC.WCharPointer)WordFactory.nullPointer());
        WinBase.CloseHandle(fileHandle);
        return fileMapping;
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    private static UnsignedWord getImageHeapFileOffset() {
        UnsignedWord value = (UnsignedWord)IMAGE_HEAP_FILE_OFFSET.get().read();
        if (value.equal(0)) {
            PointerBase ntHeader = WindowsImageHeapProvider.invokeRtlImageNtHeader(IMAGE_BASE.get());
            int rva = (int)(Isolates.IMAGE_HEAP_BEGIN.get().rawValue() - IMAGE_BASE.get().rawValue());
            value = WindowsImageHeapProvider.invokeRtlAddressInSectionTable(ntHeader, rva);
            IMAGE_HEAP_FILE_OFFSET.get().write((WordBase)value);
        }
        return value;
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    private static PointerBase invokeRtlImageNtHeader(PointerBase imageBase) {
        RtlImageNtHeader rtlImageNtHeader = (RtlImageNtHeader)WindowsUtils.getFunctionPointer(NTDLL_DLL.get(), RTL_IMAGE_NT_HEADER.get(), true);
        PointerBase ntHeader = rtlImageNtHeader.invoke(imageBase);
        if (ntHeader.isNull()) {
            CEntryPointActions.failFatally(193, RTL_IMAGE_NT_HEADER.get());
        }
        return ntHeader;
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    private static UnsignedWord invokeRtlAddressInSectionTable(PointerBase ntHeader, int rva) {
        RtlAddressInSectionTable rtlAddressInSectionTable = (RtlAddressInSectionTable)WindowsUtils.getFunctionPointer(NTDLL_DLL.get(), RTL_ADDRESS_IN_SECTION_TABLE.get(), true);
        UnsignedWord offset = (UnsignedWord)rtlAddressInSectionTable.invoke(ntHeader, WordFactory.nullPointer(), rva);
        if (offset.equal(0)) {
            CEntryPointActions.failFatally(193, RTL_ADDRESS_IN_SECTION_TABLE.get());
        }
        return offset;
    }

    private static interface RtlImageNtHeader
    extends CFunctionPointer {
        @InvokeCFunctionPointer(transition=CFunction.Transition.NO_TRANSITION)
        public PointerBase invoke(PointerBase var1);
    }

    private static interface RtlAddressInSectionTable
    extends CFunctionPointer {
        @InvokeCFunctionPointer(transition=CFunction.Transition.NO_TRANSITION)
        public PointerBase invoke(PointerBase var1, PointerBase var2, int var3);
    }
}

