/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.ContinuationsSupported;
import com.oracle.svm.core.jdk.NotLoomJDK;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.SubstrateVirtualThread;
import com.oracle.svm.core.thread.Target_jdk_internal_misc_Unsafe_JavaThreads;
import com.oracle.svm.core.thread.VirtualThreads;
import java.util.concurrent.locks.LockSupport;

@TargetClass(value=LockSupport.class, onlyWith={ContinuationsSupported.class, NotLoomJDK.class})
final class Target_java_util_concurrent_locks_LockSupport {
    @Alias
    static Target_jdk_internal_misc_Unsafe_JavaThreads U;

    Target_java_util_concurrent_locks_LockSupport() {
    }

    @Alias
    static native void setBlocker(Thread var0, Object var1);

    @Substitute
    static void unpark(Thread thread) {
        if (thread != null) {
            if (VirtualThreads.singleton().isVirtual(thread)) {
                VirtualThreads.singleton().unpark(thread);
            } else {
                U.unpark(thread);
            }
        }
    }

    @Substitute
    static void park(Object blocker) {
        Thread t = Thread.currentThread();
        Target_java_util_concurrent_locks_LockSupport.setBlocker(t, blocker);
        try {
            if (VirtualThreads.singleton().isVirtual(t)) {
                VirtualThreads.singleton().park();
            } else {
                U.park(false, 0L);
            }
        }
        finally {
            Target_java_util_concurrent_locks_LockSupport.setBlocker(t, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    static void parkNanos(Object blocker, long nanos) {
        if (nanos > 0L) {
            Thread t = Thread.currentThread();
            Target_java_util_concurrent_locks_LockSupport.setBlocker(t, blocker);
            try {
                if (VirtualThreads.singleton().isVirtual(t)) {
                    VirtualThreads.singleton().parkNanos(nanos);
                } else {
                    U.park(false, nanos);
                }
            }
            finally {
                Target_java_util_concurrent_locks_LockSupport.setBlocker(t, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    static void parkUntil(Object blocker, long deadline) {
        Thread t = Thread.currentThread();
        Target_java_util_concurrent_locks_LockSupport.setBlocker(t, blocker);
        try {
            if (VirtualThreads.singleton().isVirtual(t)) {
                VirtualThreads.singleton().parkUntil(deadline);
            } else {
                U.park(true, deadline);
            }
        }
        finally {
            Target_java_util_concurrent_locks_LockSupport.setBlocker(t, null);
        }
    }

    @Substitute
    static void park() {
        if (JavaThreads.isCurrentThreadVirtual()) {
            VirtualThreads.singleton().park();
        } else {
            U.park(false, 0L);
        }
    }

    @Substitute
    public static void parkNanos(long nanos) {
        if (nanos > 0L) {
            if (JavaThreads.isCurrentThreadVirtual()) {
                VirtualThreads.singleton().parkNanos(nanos);
                ((SubstrateVirtualThread)Thread.currentThread()).parkNanos(nanos);
            } else {
                U.park(false, nanos);
            }
        }
    }

    @Substitute
    public static void parkUntil(long deadline) {
        if (JavaThreads.isCurrentThreadVirtual()) {
            VirtualThreads.singleton().parkUntil(deadline);
        } else {
            U.park(true, deadline);
        }
    }
}

