/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.heapdump;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heapdump.HeapDumpWriterImpl;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.util.VMError;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.SignedWord;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={HeapDumpWriterImpl.AllocationFreeFileOutputStream.class})
@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
final class AllocationFreeFileOutputStreamPosix
extends HeapDumpWriterImpl.AllocationFreeFileOutputStream {
    private static final IOException preallocatedIOException = new IOException("Write failed.");
    private static final ArrayIndexOutOfBoundsException preallocatedArrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException();
    private FileOutputStream fos;
    private FileDescriptor fileDescriptor;

    AllocationFreeFileOutputStreamPosix() {
    }

    private AllocationFreeFileOutputStreamPosix(FileOutputStream fileOutputStream) throws IOException {
        this.fos = fileOutputStream;
        this.fileDescriptor = this.fos.getFD();
        if (!Platform.includedIn(Platform.LINUX.class) && !Platform.includedIn(Platform.DARWIN.class)) {
            throw VMError.unsupportedFeature("Heap dump writing currently contains Posix specific code");
        }
    }

    @Override
    public HeapDumpWriterImpl.AllocationFreeFileOutputStream newStreamFor(FileOutputStream fileOutputStream) throws IOException {
        return new AllocationFreeFileOutputStreamPosix(fileOutputStream);
    }

    @Override
    public void write(int b) throws IOException {
        CCharPointer buffer = UnsafeStackValue.get(CCharPointer.class);
        buffer.write((byte)b);
        boolean writeResult = PosixUtils.writeBytes(this.fileDescriptor, buffer, WordFactory.unsigned((int)1));
        if (!writeResult) {
            throw preallocatedIOException;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int chunkLength;
        if (b == null || off < 0 || len < 0 || b.length - off < len) {
            throw preallocatedArrayIndexOutOfBoundsException;
        }
        int chunkSize = 256;
        CCharPointer bytes = (CCharPointer)UnsafeStackValue.get(256);
        int chunkOffset = off;
        for (int inputLength = len; inputLength > 0; inputLength -= chunkLength) {
            chunkLength = Math.min(inputLength, 256);
            for (int i = 0; i < chunkLength; ++i) {
                bytes.write(i, b[chunkOffset + i]);
            }
            if (!PosixUtils.writeBytes(this.fileDescriptor, bytes, WordFactory.unsigned((int)chunkLength))) {
                throw preallocatedIOException;
            }
            chunkOffset += chunkLength;
        }
    }

    @Override
    public void close() throws IOException {
        this.fos.close();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    protected long position() {
        int fd = PosixUtils.getFD(this.fileDescriptor);
        return Unistd.lseek(fd, (SignedWord)WordFactory.zero(), Unistd.SEEK_CUR()).rawValue();
    }

    @Override
    protected long position(long offset) {
        int fd = PosixUtils.getFD(this.fileDescriptor);
        return Unistd.lseek(fd, WordFactory.signed((long)offset), Unistd.SEEK_SET()).rawValue();
    }
}

