/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.posix.headers.PosixDirectives;
import com.oracle.svm.core.posix.headers.darwin.DarwinStat;
import com.oracle.svm.core.posix.headers.linux.LinuxStat;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.struct.AllowWideningCast;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CConst;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

@CContext(value=PosixDirectives.class)
public final class PosixStat {
    @CConstant
    public static native int S_IFLNK();

    @CConstant
    public static native int S_IFDIR();

    @CConstant
    public static native int S_IRUSR();

    @CConstant
    public static native int S_IRGRP();

    @CConstant
    public static native int S_IROTH();

    @CConstant
    public static native int S_IWUSR();

    @CConstant
    public static native int S_IWGRP();

    @CConstant
    public static native int S_IWOTH();

    @CConstant
    public static native int S_IRWXU();

    @CConstant
    public static native int S_IXGRP();

    @CConstant
    public static native int S_IXOTH();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getSize(int fd) {
        int status;
        stat stat2 = UnsafeStackValue.get(stat.class);
        if (Platform.includedIn(Platform.LINUX.class)) {
            status = LinuxStat.NoTransitions.fstat(fd, stat2);
        } else if (Platform.includedIn(Platform.DARWIN.class)) {
            status = DarwinStat.NoTransitions.fstat(fd, stat2);
        } else {
            throw VMError.shouldNotReachHere("Unsupported platform");
        }
        if (status == 0) {
            return stat2.st_size();
        }
        return -1L;
    }

    @Fold
    public static int sizeOfStatStruct() {
        if (Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class)) {
            return SizeOf.get(stat.class);
        }
        throw VMError.shouldNotReachHere("Unsupported platform");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int st_uid(stat buf) {
        if (Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class)) {
            return buf.st_uid();
        }
        throw VMError.shouldNotReachHere("Unsupported platform");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean S_ISLNK(stat buf) {
        return PosixStat.st_mode(buf).and(PosixStat.S_IFLNK()).equal(PosixStat.S_IFLNK());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean S_ISDIR(stat buf) {
        return PosixStat.st_mode(buf).and(PosixStat.S_IFDIR()).equal(PosixStat.S_IFDIR());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord st_mode(stat buf) {
        if (Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class)) {
            return buf.st_mode();
        }
        throw VMError.shouldNotReachHere("Unsupported platform");
    }

    public static UnsignedWord st_nlink(stat buf) {
        if (Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class)) {
            return buf.st_nlink();
        }
        throw VMError.shouldNotReachHere("Unsupported platform");
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private PosixStat() {
    }

    @CStruct(addStructKeyword=true)
    public static interface stat
    extends PointerBase {
        @CField
        public long st_ino();

        @CField
        @AllowWideningCast
        public UnsignedWord st_mode();

        @CField
        public int st_uid();

        @CField
        public long st_size();

        @CField
        @AllowWideningCast
        public UnsignedWord st_nlink();
    }

    public static class NoTransitions {
        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int mkdir(@CConst CCharPointer var0, int var1);

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int fstat(int fd, stat buf) {
            if (Platform.includedIn(Platform.LINUX.class)) {
                return LinuxStat.NoTransitions.fstat(fd, buf);
            }
            if (Platform.includedIn(Platform.DARWIN.class)) {
                return DarwinStat.NoTransitions.fstat(fd, buf);
            }
            throw VMError.shouldNotReachHere("Unsupported platform");
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int lstat(CCharPointer path, stat buf) {
            if (Platform.includedIn(Platform.LINUX.class)) {
                return LinuxStat.NoTransitions.lstat(path, buf);
            }
            if (Platform.includedIn(Platform.DARWIN.class)) {
                return DarwinStat.NoTransitions.lstat(path, buf);
            }
            throw VMError.shouldNotReachHere("Unsupported platform");
        }
    }
}

