/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.log;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.jdk.JDKUtils;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.util.VMError;
import java.nio.charset.StandardCharsets;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class RealLog
extends Log {
    private boolean autoflush = false;
    private int indent = 0;
    private static final char[] NULL_CHARS = "null".toCharArray();
    private static final byte[] NEWLINE = System.lineSeparator().getBytes(StandardCharsets.US_ASCII);
    private static final byte[] trueString = Boolean.TRUE.toString().getBytes();
    private static final byte[] falseString = Boolean.FALSE.toString().getBytes();
    private static final char spaceChar = ' ';

    protected RealLog() {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log string(String value) {
        this.rawString(value == null ? "null" : value);
        return this;
    }

    @Override
    @NeverInline(value="Logging is always slow-path code")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log string(String str, int fill, int align) {
        int spaces = fill - str.length();
        if (align == 2) {
            this.spaces(spaces);
        }
        this.string(str);
        if (align == 1) {
            this.spaces(spaces);
        }
        return this;
    }

    @Override
    @NeverInline(value="Logging is always slow-path code")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log string(String value, int maxLen) {
        this.rawString(value, maxLen);
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log string(char[] value) {
        this.rawString(value == null ? NULL_CHARS : value);
        return this;
    }

    @Override
    @NeverInline(value="Logging is always slow-path code")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log string(byte[] value, int offset, int length) {
        if (value == null) {
            this.rawString("null");
        } else if (offset < 0 || offset > value.length || length < 0 || offset + length > value.length || offset + length < 0) {
            this.rawString("OUT OF BOUNDS");
        } else if (Heap.getHeap().isInImageHeap(value)) {
            this.rawBytes((CCharPointer)NonmovableArrays.addressOf(NonmovableArrays.fromImageHeap((Object)value), offset), WordFactory.unsigned((int)length));
        } else {
            this.rawBytes(value, offset, length);
        }
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log string(byte[] value) {
        this.string(value, 0, value.length);
        return this;
    }

    @NeverInline(value="Logging is always slow-path code")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    private void rawBytes(Object value, int offset, int length) {
        int chunkLength;
        int chunkSize = 256;
        CCharPointer bytes = (CCharPointer)UnsafeStackValue.get(256);
        int chunkOffset = offset;
        for (int inputLength = length; inputLength > 0; inputLength -= chunkLength) {
            chunkLength = Math.min(inputLength, 256);
            for (int i = 0; i < chunkLength; ++i) {
                int index = chunkOffset + i;
                byte b = value instanceof String ? (byte)RealLog.charAt((String)value, index) : (value instanceof char[] ? (byte)((char[])value)[index] : ((byte[])value)[index]);
                bytes.write(i, b);
            }
            this.rawBytes(bytes, WordFactory.unsigned((int)chunkLength));
            chunkOffset += chunkLength;
        }
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="String.charAt can allocate exception, but we know that our access is in bounds")
    private static char charAt(String s, int index) {
        return s.charAt(index);
    }

    @Override
    @NeverInline(value="Logging is always slow-path code")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log string(CCharPointer value) {
        if (value.notEqual((ComparableWord)WordFactory.nullPointer())) {
            this.rawBytes(value, SubstrateUtil.strlen(value));
        } else {
            this.rawString("null");
        }
        return this;
    }

    @Override
    @NeverInline(value="Logging is always slow-path code")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log character(char value) {
        CCharPointer bytes = UnsafeStackValue.get(CCharPointer.class);
        bytes.write((byte)value);
        this.rawBytes(bytes, WordFactory.unsigned((int)1));
        return this;
    }

    @Override
    @NeverInline(value="Logging is always slow-path code")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log newline() {
        this.string(NEWLINE);
        if (this.autoflush) {
            this.flush();
        }
        this.spaces(this.indent);
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log number(long value, int radix, boolean signed) {
        this.number(value, radix, signed, 0, 0);
        return this;
    }

    @NeverInline(value="Logging is always slow-path code")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    private Log number(long value, int radix, boolean signed, int fill, int align) {
        int spaces;
        if (radix < 2 || radix > 36) {
            return this;
        }
        int chunkSize = 65;
        CCharPointer bytes = UnsafeStackValue.get(65, CCharPointer.class);
        int charPos = 65;
        boolean negative = signed && value < 0L;
        long curValue = negative ? -value : value;
        while (UnsignedMath.aboveOrEqual((long)curValue, (long)radix)) {
            bytes.write(--charPos, RealLog.digit(Long.remainderUnsigned(curValue, radix)));
            curValue = Long.divideUnsigned(curValue, radix);
        }
        bytes.write(--charPos, RealLog.digit(curValue));
        if (negative) {
            bytes.write(--charPos, (byte)45);
        }
        int length = 65 - charPos;
        if (align == 2) {
            spaces = fill - length;
            this.spaces(spaces);
        }
        this.rawBytes(bytes.addressOf(charPos), WordFactory.unsigned((int)length));
        if (align == 1) {
            spaces = fill - length;
            this.spaces(spaces);
        }
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log signed(WordBase value) {
        this.number(value.rawValue(), 10, true);
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log signed(int value) {
        this.number(value, 10, true);
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log signed(long value) {
        this.number(value, 10, true);
        return this;
    }

    @Override
    public Log signed(long value, int fill, int align) {
        this.number(value, 10, true, fill, align);
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log unsigned(WordBase value) {
        this.number(value.rawValue(), 10, false);
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log unsigned(WordBase value, int fill, int align) {
        this.number(value.rawValue(), 10, false, fill, align);
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log unsigned(int value) {
        this.number((long)value & 0xFFFFFFFFL, 10, false);
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log unsigned(long value) {
        this.number(value, 10, false);
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log unsigned(long value, int fill, int align) {
        this.number(value, 10, false, fill, align);
        return this;
    }

    @Override
    @NeverInline(value="Logging is always slow-path code")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log rational(long numerator, long denominator, long decimals) {
        if (denominator == 0L) {
            throw VMError.shouldNotReachHere("Division by zero");
        }
        if (decimals < 0L) {
            throw VMError.shouldNotReachHere("Number of decimals smaller than 0");
        }
        long value = numerator / denominator;
        this.unsigned(value);
        if (decimals > 0L) {
            this.character('.');
            long positiveNumerator = Math.abs(numerator);
            long positiveDenominator = Math.abs(denominator);
            long remainder = positiveNumerator % positiveDenominator;
            int i = 0;
            while ((long)i < decimals) {
                this.unsigned((remainder *= 10L) / positiveDenominator);
                remainder %= positiveDenominator;
                ++i;
            }
        }
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log rational(UnsignedWord numerator, long denominator, long decimals) {
        return this.rational(numerator.rawValue(), denominator, decimals);
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log hex(WordBase value) {
        this.string("0x").number(value.rawValue(), 16, false);
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log hex(int value) {
        this.string("0x").number((long)value & 0xFFFFFFFFL, 16, false);
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log hex(long value) {
        this.string("0x").number(value, 16, false);
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log bool(boolean value) {
        this.string(value ? trueString : falseString);
        return this;
    }

    @Override
    @NeverInline(value="Logging is always slow-path code")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log object(Object value) {
        if (value == null) {
            this.string("null");
        } else {
            this.string(value.getClass().getName());
            this.string("@");
            this.zhex((WordBase)Word.objectToUntrackedPointer((Object)value));
        }
        return this;
    }

    @Override
    @NeverInline(value="Logging is always slow-path code")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log spaces(int value) {
        for (int i = 0; i < value; ++i) {
            this.character(' ');
        }
        return this;
    }

    @Override
    @NeverInline(value="Logging is always slow-path code")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log flush() {
        ((LogHandler)ImageSingletons.lookup(LogHandler.class)).flush();
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log autoflush(boolean onOrOff) {
        this.autoflush = onOrOff;
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log redent(boolean addOrRemove) {
        int delta = addOrRemove ? 2 : -2;
        this.indent = Math.max(0, this.indent + delta);
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public final Log indent(boolean addOrRemove) {
        this.redent(addOrRemove).newline();
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log resetIndentation() {
        this.indent = 0;
        return this;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    private static byte digit(long d) {
        return (byte)(d + (long)(d < 10L ? 48 : 87));
    }

    @NeverInline(value="Logging is always slow-path code")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    protected Log rawBytes(CCharPointer bytes, UnsignedWord length) {
        ((LogHandler)ImageSingletons.lookup(LogHandler.class)).log(bytes, length);
        return this;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    private void rawString(String value) {
        this.rawBytes(value, 0, value.length());
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    private void rawString(String value, int maxLength) {
        int length = Math.min(value.length(), maxLength);
        this.rawBytes(value, 0, length);
        if (value.length() > length) {
            this.rawString("...");
        }
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    private void rawString(char[] value) {
        this.rawBytes(value, 0, value.length);
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log zhex(WordBase value) {
        this.zhex(value.rawValue());
        return this;
    }

    @Override
    @NeverInline(value="Logging is always slow-path code")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log zhex(long value) {
        this.string("0x");
        int zeros = Long.numberOfLeadingZeros(value);
        int hexZeros = zeros / 4;
        for (int i = 0; i < hexZeros; ++i) {
            this.character('0');
        }
        if (value != 0L) {
            this.number(value, 16, false);
        }
        return this;
    }

    @NeverInline(value="Logging is always slow-path code")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    private Log zhex(int value, int wordSizeInBytes) {
        this.string("0x");
        int zeros = Integer.numberOfLeadingZeros(value) - 32 + wordSizeInBytes * 8;
        int hexZeros = zeros / 4;
        for (int i = 0; i < hexZeros; ++i) {
            this.character('0');
        }
        if (value != 0) {
            this.number((long)value & 0xFFFFFFFFL, 16, false);
        }
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log zhex(int value) {
        this.zhex(value, 4);
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log zhex(short value) {
        short intValue = value;
        this.zhex(intValue & 0xFFFF, 2);
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log zhex(byte value) {
        byte intValue = value;
        this.zhex(intValue & 0xFF, 1);
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log hexdump(PointerBase from, int wordSize, int numWords) {
        return this.hexdump(from, wordSize, numWords, 16);
    }

    @Override
    @NeverInline(value="Logging is always slow-path code")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log hexdump(PointerBase from, int wordSize, int numWords, int bytesPerLine) {
        Pointer base = (Pointer)WordFactory.pointer((long)from.rawValue());
        int sanitizedWordsize = wordSize > 0 ? Integer.highestOneBit(Math.min(wordSize, 8)) : 2;
        for (int offset = 0; offset < sanitizedWordsize * numWords; offset += sanitizedWordsize) {
            if (offset % bytesPerLine == 0) {
                this.zhex((WordBase)base.add(offset));
                this.string(":");
            }
            this.string(" ");
            switch (sanitizedWordsize) {
                case 1: {
                    this.zhex(base.readByte(offset));
                    break;
                }
                case 2: {
                    this.zhex(base.readShort(offset));
                    break;
                }
                case 4: {
                    this.zhex(base.readInt(offset));
                    break;
                }
                case 8: {
                    this.zhex(base.readLong(offset));
                }
            }
            if ((offset + sanitizedWordsize) % bytesPerLine != 0 || offset + sanitizedWordsize >= sanitizedWordsize * numWords) continue;
            this.newline();
        }
        return this;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log exception(Throwable t) {
        this.exception(t, Integer.MAX_VALUE);
        return this;
    }

    @Override
    @NeverInline(value="Logging is always slow-path code")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
    public Log exception(Throwable t, int maxFrames) {
        if (t == null) {
            this.object(t);
            return this;
        }
        Throwable cur = t;
        int maxCauses = 25;
        for (int i = 0; i < maxCauses && cur != null; ++i) {
            if (i > 0) {
                this.newline().string("Caused by: ");
            }
            String detailMessage = JDKUtils.getRawMessage(cur);
            StackTraceElement[] stackTrace = JDKUtils.getRawStackTrace(cur);
            this.string(cur.getClass().getName()).string(": ").string(detailMessage);
            if (stackTrace != null) {
                int j;
                for (j = 0; j < stackTrace.length && j < maxFrames; ++j) {
                    StackTraceElement element = stackTrace[j];
                    if (element == null) continue;
                    this.newline();
                    this.string("    at ").string(element.getClassName()).string(".").string(element.getMethodName());
                    this.string("(").string(element.getFileName()).string(":").signed(element.getLineNumber()).string(")");
                }
                int remaining = stackTrace.length - j;
                if (remaining > 0) {
                    this.newline().string("    ... ").unsigned(remaining).string(" more");
                }
            }
            cur = JDKUtils.getRawCause(cur);
        }
        return this;
    }
}

