/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni;

import com.oracle.svm.core.jni.JNIObjectHandles;
import com.oracle.svm.core.jni.access.JNIAccessibleField;
import com.oracle.svm.core.jni.headers.JNIFieldId;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import jdk.internal.misc.Unsafe;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;

public class JNIObjectFieldAccess {
    @Fold
    public static JNIObjectFieldAccess singleton() {
        return (JNIObjectFieldAccess)ImageSingletons.lookup(JNIObjectFieldAccess.class);
    }

    public JNIObjectHandle getObjectField(JNIObjectHandle obj, JNIFieldId fieldId) {
        Object o = JNIObjectHandles.getObject(obj);
        long offset = JNIAccessibleField.getOffsetFromId(fieldId).rawValue();
        Object result = this.getObjectField0(o, offset);
        return JNIObjectHandles.createLocal(result);
    }

    protected Object getObjectField0(Object obj, long offset) {
        return Unsafe.getUnsafe().getReference(obj, offset);
    }
}

