/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Containers;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrEarlier;
import com.oracle.svm.core.jdk.JDK17OrEarlier;
import com.oracle.svm.core.jdk.JDK17OrLater;
import com.oracle.svm.core.jdk.JDK19OrLater;
import com.oracle.svm.core.jdk.JDK20OrLater;
import com.oracle.svm.core.jfr.HasChunkRotationMonitorField;
import com.oracle.svm.core.jfr.HasFileDeltaChangeField;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrJavaEvents;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_EventWriter;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_JVM_Util;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_event_EventConfiguration;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_handlers_EventHandler;
import com.oracle.svm.core.jfr.traceid.JfrTraceId;
import com.oracle.svm.core.util.VMError;
import java.util.List;
import jdk.internal.event.Event;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogTag;
import org.graalvm.nativeimage.ProcessProperties;

@TargetClass(value=JVM.class)
public final class Target_jdk_jfr_internal_JVM {
    @Alias
    @TargetElement(onlyWith={HasChunkRotationMonitorField.class})
    static Object CHUNK_ROTATION_MONITOR;
    @Alias
    @TargetElement(onlyWith={HasFileDeltaChangeField.class})
    static Object FILE_DELTA_CHANGE;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private volatile boolean nativeOK;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private volatile boolean recording;

    @Substitute
    private static void registerNatives() {
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public void markChunkFinal() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().markChunkFinal();
    }

    @Substitute
    public void beginRecording() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().beginRecording();
    }

    @Substitute
    @Uninterruptible(reason="Needed for calling SubstrateJVM.isRecording().")
    @TargetElement(onlyWith={JDK17OrLater.class})
    public boolean isRecording() {
        if (!HasJfrSupport.get()) {
            return false;
        }
        return SubstrateJVM.get().isRecording();
    }

    @Substitute
    public void endRecording() {
        if (!HasJfrSupport.get()) {
            return;
        }
        SubstrateJVM.get().endRecording();
    }

    @Substitute
    public static long counterTime() {
        return JfrTicks.elapsedTicks();
    }

    @Substitute
    public boolean emitEvent(long eventTypeId, long timestamp, long when) {
        return false;
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public List<Class<? extends Event>> getAllEventClasses() {
        return JfrJavaEvents.getAllEventClasses();
    }

    @Substitute
    @TargetElement(name="getAllEventClasses", onlyWith={JDK11OrEarlier.class})
    public List<Class<? extends jdk.jfr.Event>> getAllEventClassesJDK11() {
        return JfrJavaEvents.getJfrEventClasses();
    }

    @Substitute
    public long getUnloadedEventClassCount() {
        return 0L;
    }

    @Substitute
    @Uninterruptible(reason="Needed for SubstrateJVM.getClassId().")
    public static long getClassId(Class<?> clazz) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().getClassId(clazz);
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    public static long getClassIdNonIntrinsic(Class<?> clazz) {
        return Target_jdk_jfr_internal_JVM.getClassId(clazz);
    }

    @Substitute
    public String getPid() {
        long id = ProcessProperties.getProcessID();
        return String.valueOf(id);
    }

    @Substitute
    @Uninterruptible(reason="Needed for SubstrateJVM.getStackTraceId().")
    public long getStackTraceId(int skipCount) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().getStackTraceId(skipCount);
    }

    @Substitute
    public long getThreadId(Thread t) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.getThreadId(t);
    }

    @Substitute
    public long getTicksFrequency() {
        return JfrTicks.getTicksFrequency();
    }

    @Substitute
    public static void log(int tagSetId, int level, String message) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().log(tagSetId, level, message);
    }

    @Substitute
    public static void logEvent(int level, String[] lines, boolean system) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().logEvent(level, lines, system);
    }

    @Substitute
    public static void subscribeLogLevel(LogTag lt, int tagSetId) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().subscribeLogLevel(lt, tagSetId);
    }

    @Substitute
    public synchronized void retransformClasses(Class<?>[] classes) {
    }

    @Substitute
    public void setEnabled(long eventTypeId, boolean enabled) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setEnabled(eventTypeId, enabled);
    }

    @Substitute
    public void setFileNotification(long delta) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setFileNotification(delta);
    }

    @Substitute
    public void setGlobalBufferCount(long count) throws IllegalArgumentException, IllegalStateException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setGlobalBufferCount(count);
    }

    @Substitute
    public void setGlobalBufferSize(long size) throws IllegalArgumentException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setGlobalBufferSize(size);
    }

    @Substitute
    public void setMemorySize(long size) throws IllegalArgumentException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setMemorySize(size);
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    public void setMethodSamplingInterval(long type, long intervalMillis) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setMethodSamplingInterval(type, intervalMillis);
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public void setMethodSamplingPeriod(long type, long intervalMillis) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setMethodSamplingInterval(type, intervalMillis);
    }

    @Substitute
    public void setOutput(String file) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setOutput(file);
    }

    @Substitute
    public void setForceInstrumentation(boolean force) {
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    public void setSampleThreads(boolean sampleThreads) throws IllegalStateException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setSampleThreads(sampleThreads);
    }

    @Substitute
    public void setCompressedIntegers(boolean compressed) throws IllegalStateException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setCompressedIntegers(compressed);
    }

    @Substitute
    public void setStackDepth(int depth) throws IllegalArgumentException, IllegalStateException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setStackDepth(depth);
    }

    @Substitute
    public void setStackTraceEnabled(long eventTypeId, boolean enabled) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setStackTraceEnabled(eventTypeId, enabled);
    }

    @Substitute
    public void setThreadBufferSize(long size) throws IllegalArgumentException, IllegalStateException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setThreadBufferSize(size);
    }

    @Substitute
    public boolean setThreshold(long eventTypeId, long ticks) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().setThreshold(eventTypeId, ticks);
    }

    @Substitute
    public void storeMetadataDescriptor(byte[] bytes) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().storeMetadataDescriptor(bytes);
    }

    @Substitute
    public boolean getAllowedToDoEventRetransforms() {
        return false;
    }

    @Substitute
    private boolean createJFR(boolean simulateFailure) throws IllegalStateException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().createJFR(simulateFailure);
    }

    @Substitute
    private boolean destroyJFR() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().destroyJFR();
    }

    @Substitute
    public boolean isAvailable() {
        return HasJfrSupport.get();
    }

    @Substitute
    public double getTimeConversionFactor() {
        return 1.0;
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class, JDK17OrEarlier.class})
    public boolean setHandler(Class<? extends Event> eventClass, Target_jdk_jfr_internal_handlers_EventHandler handler) {
        throw VMError.shouldNotReachHere("eventHandler does not exist for: " + eventClass);
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class, JDK17OrEarlier.class})
    public Object getHandler(Class<? extends Event> eventClass) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.getHandler(eventClass);
    }

    @Substitute
    public long getTypeId(Class<?> clazz) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return JfrTraceId.getTraceId(clazz);
    }

    @Substitute
    public static Object getEventWriter() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().getEventWriter();
    }

    @Substitute
    public static Target_jdk_jfr_internal_EventWriter newEventWriter() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().newEventWriter();
    }

    @Substitute
    public static boolean flush(Target_jdk_jfr_internal_EventWriter writer, int uncommittedSize, int requestedSize) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().flush(writer, uncommittedSize, requestedSize);
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public void flush() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().flush();
    }

    @Substitute
    public void setRepositoryLocation(String dirText) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setRepositoryLocation(dirText);
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public void setDumpPath(String dumpPathText) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setDumpPath(dumpPathText);
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public String getDumpPath() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().getDumpPath();
    }

    @Substitute
    public void abort(String errorMsg) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().abort(errorMsg);
    }

    @Substitute
    public static boolean addStringConstant(long id, String s) {
        return false;
    }

    @Substitute
    public void uncaughtException(Thread thread, Throwable t) {
    }

    @Substitute
    public boolean setCutoff(long eventTypeId, long cutoffTicks) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().setCutoff(eventTypeId, cutoffTicks);
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public boolean setThrottle(long eventTypeId, long eventSampleSize, long periodMs) {
        return true;
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    public void emitOldObjectSamples(long cutoff, boolean emitAll) {
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public void emitOldObjectSamples(long cutoff, boolean emitAll, boolean skipBFS) {
    }

    @Substitute
    public boolean shouldRotateDisk() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().shouldRotateDisk();
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public void include(Thread thread) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        JfrThreadLocal.setExcluded(thread, false);
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public void exclude(Thread thread) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        JfrThreadLocal.setExcluded(thread, true);
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public boolean isExcluded(Thread thread) {
        if (!HasJfrSupport.get()) {
            return true;
        }
        return JfrThreadLocal.isThreadExcluded(thread);
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public boolean isExcluded(Class<? extends Event> eventClass) {
        return !HasJfrSupport.get();
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public boolean isInstrumented(Class<? extends Event> eventClass) {
        return HasJfrSupport.get();
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public long getChunkStartNanos() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().getChunkStartNanos();
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public boolean setConfiguration(Class<? extends Event> eventClass, Target_jdk_jfr_internal_event_EventConfiguration configuration) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().setConfiguration(eventClass, configuration);
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public Object getConfiguration(Class<? extends Event> eventClass) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().getConfiguration(eventClass);
    }

    @Substitute
    public long getTypeId(String name) {
        return -1L;
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public boolean isContainerized() {
        return Containers.isContainerized();
    }

    @Substitute
    @TargetElement(onlyWith={JDK20OrLater.class})
    public long hostTotalMemory() {
        return -1L;
    }
}

