/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrEarlier;
import com.oracle.svm.core.jdk.ModuleUtil;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntry;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;

@TargetClass(value=Module.class)
final class Target_java_lang_Module {
    Target_java_lang_Module() {
    }

    @Substitute
    private InputStream getResourceAsStream(String resourceName) {
        ResourceStorageEntry res;
        String resName = resourceName;
        if (resName.startsWith("/")) {
            resName = resName.substring(1);
        }
        return (res = Resources.get(SubstrateUtil.cast(this, Module.class), resName)) == null ? null : new ByteArrayInputStream(res.getData().get(0));
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private static void defineModule0(Module module, boolean isOpen, String version, String location, String[] pns) {
        ModuleUtil.defineModule(module, isOpen, Arrays.asList(pns));
    }

    @Substitute
    private static void addReads0(Module from, Module to) {
        if (Objects.isNull(from)) {
            throw new NullPointerException("from_module is null");
        }
    }

    @Substitute
    private static void addExports0(Module from, String pn, Module to) {
        if (Objects.isNull(to)) {
            throw new NullPointerException("to_module is null");
        }
        ModuleUtil.checkFromModuleAndPackageNullability(from, pn);
        ModuleUtil.checkIsPackageContainedInModule(pn, from);
    }

    @Substitute
    private static void addExportsToAll0(Module from, String pn) {
        ModuleUtil.checkFromModuleAndPackageNullability(from, pn);
        ModuleUtil.checkIsPackageContainedInModule(pn, from);
    }

    @Substitute
    private static void addExportsToAllUnnamed0(Module from, String pn) {
        ModuleUtil.checkFromModuleAndPackageNullability(from, pn);
        if (from.isNamed()) {
            ModuleUtil.checkIsPackageContainedInModule(pn, from);
        }
    }
}

