/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public abstract class ObjectHeader {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected ObjectHeader() {
    }

    public abstract int getReservedBitsMask();

    public abstract long encodeAsImageHeapObjectHeader(ImageHeapObject var1, long var2);

    public abstract Word encodeAsTLABObjectHeader(DynamicHub var1);

    public abstract Word encodeAsUnmanagedObjectHeader(DynamicHub var1);

    public abstract void verifyDynamicHubOffsetInImageHeap(long var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public DynamicHub dynamicHubFromObjectHeader(Word header) {
        return (DynamicHub)this.extractPotentialDynamicHubFromHeader(header).toObject();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static DynamicHub readDynamicHubFromObject(Object o) {
        return KnownIntrinsics.readHub(o);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Word readHeaderFromPointer(Pointer objectPointer) {
        if (ObjectHeader.getReferenceSize() == 4) {
            return (Word)WordFactory.unsigned((int)objectPointer.readInt(ObjectHeader.getHubOffset()));
        }
        return (Word)objectPointer.readWord(ObjectHeader.getHubOffset());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Word readHeaderFromObject(Object o) {
        if (ObjectHeader.getReferenceSize() == 4) {
            return (Word)WordFactory.unsigned((int)ObjectAccess.readInt((Object)o, (int)ObjectHeader.getHubOffset()));
        }
        return (Word)ObjectAccess.readWord((Object)o, (int)ObjectHeader.getHubOffset());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public DynamicHub readDynamicHubFromPointer(Pointer ptr) {
        Word header = ObjectHeader.readHeaderFromPointer(ptr);
        return this.dynamicHubFromObjectHeader(header);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer readPotentialDynamicHubFromPointer(Pointer ptr) {
        Word potentialHeader = ObjectHeader.readHeaderFromPointer(ptr);
        return this.extractPotentialDynamicHubFromHeader(potentialHeader);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract Pointer extractPotentialDynamicHubFromHeader(Word var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract void initializeHeaderOfNewObject(Pointer var1, Word var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean pointsToObjectHeader(Pointer ptr) {
        Pointer potentialDynamicHub = this.readPotentialDynamicHubFromPointer(ptr);
        return this.isDynamicHub(potentialDynamicHub);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isEncodedObjectHeader(Word potentialHeader) {
        Pointer potentialDynamicHub = this.extractPotentialDynamicHubFromHeader(potentialHeader);
        return this.isDynamicHub(potentialDynamicHub);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract boolean hasOptionalIdentityHashField(Word var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract boolean hasIdentityHashFromAddress(Word var1);

    @Uninterruptible(reason="Prevent a GC interfering with the object's identity hash state.", callerMustBe=true)
    public abstract void setIdentityHashFromAddress(Pointer var1, Word var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean isDynamicHub(Pointer potentialDynamicHub) {
        if (Heap.getHeap().isInImageHeap(potentialDynamicHub)) {
            Pointer potentialHubOfDynamicHub = this.readPotentialDynamicHubFromPointer(potentialDynamicHub);
            return potentialHubOfDynamicHub.equal((UnsignedWord)Word.objectToUntrackedPointer(DynamicHub.class));
        }
        return false;
    }

    @Fold
    protected static int getReferenceSize() {
        return ConfigurationValues.getObjectLayout().getReferenceSize();
    }

    @Fold
    protected static int getHubOffset() {
        return ConfigurationValues.getObjectLayout().getHubOffset();
    }
}

