/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.word;

import com.oracle.svm.core.graal.word.DynamicHubAccess;
import com.oracle.svm.core.graal.word.SubstrateOperation;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.gc.BarrierSet;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.word.WordOperationPlugin;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.word.LocationIdentity;

public class SubstrateWordOperationPlugins
extends WordOperationPlugin {
    public SubstrateWordOperationPlugins(SnippetReflectionProvider snippetReflection, WordTypes wordTypes, BarrierSet barrierSet) {
        super(snippetReflection, wordTypes, barrierSet);
    }

    public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        if (!this.wordTypes.isWordOperation(method) && !method.getDeclaringClass().equals(b.getMetaAccess().lookupJavaType(DynamicHubAccess.class))) {
            return false;
        }
        SubstrateOperation operation = (SubstrateOperation)AnnotationAccess.getAnnotation((AnnotatedElement)method, SubstrateOperation.class);
        if (operation == null) {
            this.processWordOperation(b, args, this.wordTypes.getWordOperation(method, b.getMethod().getDeclaringClass()));
            return true;
        }
        this.processSubstrateOperation(b, method, args, operation);
        return true;
    }

    protected void processSubstrateOperation(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args, SubstrateOperation operation) {
        switch (operation.opcode()) {
            case READ_FROM_HUB: {
                JavaKind returnKind = method.getSignature().getReturnKind();
                GraalError.guarantee((args.length == 4 ? 1 : 0) != 0, (String)"arg length=%d operation=%s", (Object)args.length, (Object)operation);
                JavaKind readKind = this.wordTypes.asKind(method.getSignature().getReturnType(method.getDeclaringClass()));
                AddressNode address = this.makeAddress(b, args[0], args[1]);
                assert (args[2].isConstant()) : args[2];
                LocationIdentity location = (LocationIdentity)this.snippetReflection.asObject(LocationIdentity.class, args[2].asJavaConstant());
                assert (location != null) : this.snippetReflection.asObject(Object.class, args[2].asJavaConstant());
                FixedAccessNode read = (FixedAccessNode)b.add((ValueNode)new ReadNode(address, location, StampFactory.forKind((JavaKind)readKind), BarrierType.NONE, MemoryOrderMode.PLAIN));
                if (!(args[3] instanceof ConstantNode)) {
                    read.setGuard((GuardingNode)args[3]);
                }
                b.push(returnKind, (ValueNode)read);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere((String)("Unknown operation " + operation));
            }
        }
    }
}

