/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.DeoptimizingFixedWithNextNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.FixedValueAnchorNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8, allowedUsageTypes={InputType.Memory})
public class CEntryPointLeaveNode
extends DeoptimizingFixedWithNextNode
implements Simplifiable,
Lowerable,
SingleMemoryKill,
DeoptimizingNode.DeoptBefore {
    public static final NodeClass<CEntryPointLeaveNode> TYPE = NodeClass.create(CEntryPointLeaveNode.class);
    protected final LeaveAction leaveAction;
    @Node.OptionalInput
    protected ValueNode exception;
    private boolean returnValueAnchored;

    public CEntryPointLeaveNode(LeaveAction leaveAction) {
        this(leaveAction, null);
    }

    public CEntryPointLeaveNode(LeaveAction leaveAction, ValueNode exception) {
        super(TYPE, StampFactory.forKind((JavaKind)JavaKind.Int));
        assert (leaveAction == LeaveAction.ExceptionAbort == (exception != null));
        this.leaveAction = leaveAction;
        this.exception = exception;
    }

    public LeaveAction getLeaveAction() {
        return this.leaveAction;
    }

    public ValueNode getException() {
        return this.exception;
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public boolean canDeoptimize() {
        return true;
    }

    public boolean canUseAsStateDuring() {
        return true;
    }

    public void simplify(SimplifierTool tool) {
        if (tool.allUsagesAvailable() && !this.returnValueAnchored) {
            this.returnValueAnchored = true;
            this.anchorReturnValue();
        }
    }

    private void anchorReturnValue() {
        if (this.graph().method().getSignature().getReturnKind() == JavaKind.Void) {
            return;
        }
        int nodesAnchored = this.anchorNodes((Node)this);
        if (this.leaveAction == LeaveAction.ExceptionAbort) {
            VMError.guarantee(nodesAnchored == 0, "Unexpected values were anchored in method %s as ExceptionAbort must not have any return value.", this.graph().method());
        } else {
            VMError.guarantee(nodesAnchored == 1, "An unexpected number of values was anchored in method %s", this.graph().method());
        }
    }

    private int anchorNodes(Node n) {
        int anchoredNodes = 0;
        Node cur = n;
        while (cur instanceof FixedWithNextNode) {
            cur = ((FixedWithNextNode)cur).next();
        }
        if (cur instanceof IfNode) {
            for (Node sux : cur.successors()) {
                anchoredNodes += this.anchorNodes(sux);
            }
        } else if (cur instanceof ReturnNode) {
            ReturnNode returnNode = (ReturnNode)cur;
            this.anchorValue((FixedNode)returnNode, returnNode.result());
            ++anchoredNodes;
        } else if (!(cur instanceof LoweredDeadEndNode)) {
            if (cur instanceof EndNode && CEntryPointLeaveNode.isAllowedMerge(((EndNode)cur).merge())) {
                MergeNode merge = (MergeNode)((EndNode)cur).merge();
                this.anchorValue((FixedNode)merge, (ValueNode)merge.phis().first());
                ++anchoredNodes;
            } else {
                throw VMError.shouldNotReachHere("Unexpected control flow structure after CEntryPointLeaveNode. Disallowed node " + cur + " in method " + ((StructuredGraph)cur.graph()).method().format("%H.%n(%p)"));
            }
        }
        return anchoredNodes;
    }

    private static boolean isAllowedMerge(AbstractMergeNode merge) {
        return merge instanceof MergeNode && merge.phis().count() == 1 && merge.next() instanceof ReturnNode;
    }

    private void anchorValue(FixedNode parent, ValueNode value) {
        assert (value != null) : "methods with return type void are already excluded";
        if (value != this) {
            FixedValueAnchorNode anchoredValue = (FixedValueAnchorNode)this.graph().add((Node)new FixedValueAnchorNode(value));
            this.graph().addBeforeFixed((FixedNode)this, (FixedWithNextNode)anchoredValue);
            parent.replaceAllInputs((Node)value, (Node)anchoredValue);
        }
    }

    public static enum LeaveAction {
        Leave,
        DetachThread,
        TearDownIsolate,
        ExceptionAbort;

    }
}

