/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code;

import com.oracle.svm.core.CalleeSavedRegisters;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.UserError;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@Platforms(value={Platform.HOSTED_ONLY.class})
public @interface StubCallingConvention {

    public static class Utils {
        public static boolean hasStubCallingConvention(ResolvedJavaMethod method) {
            boolean result = false;
            if (CalleeSavedRegisters.supportedByPlatform()) {
                SubstrateForeignCallTarget foreignCallTargetAnnotation = (SubstrateForeignCallTarget)AnnotationAccess.getAnnotation((AnnotatedElement)method, SubstrateForeignCallTarget.class);
                result = foreignCallTargetAnnotation != null && foreignCallTargetAnnotation.stubCallingConvention() ? true : AnnotationAccess.isAnnotationPresent((AnnotatedElement)method, StubCallingConvention.class);
            }
            if (result && !method.isStatic()) {
                throw UserError.abort("Method that uses stub calling convention must be static: %s", method);
            }
            return result;
        }
    }
}

