/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.containers.cgroupv2;

import com.oracle.svm.core.containers.CgroupInfo;
import com.oracle.svm.core.containers.CgroupSubsystem;
import com.oracle.svm.core.containers.CgroupSubsystemController;
import com.oracle.svm.core.containers.CgroupUtil;
import com.oracle.svm.core.containers.cgroupv2.CgroupV2SubsystemController;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class CgroupV2Subsystem
implements CgroupSubsystem {
    private static volatile CgroupV2Subsystem INSTANCE;
    private static final long[] LONG_ARRAY_NOT_SUPPORTED;
    private static final int[] INT_ARRAY_UNAVAILABLE;
    private final CgroupSubsystemController unified;
    private static final String PROVIDER_NAME = "cgroupv2";
    private static final int PER_CPU_SHARES = 1024;
    private static final Object EMPTY_STR;
    private static final long NO_SWAP = 0L;

    private CgroupV2Subsystem(CgroupSubsystemController unified) {
        this.unified = unified;
    }

    private long getLongVal(String file, long defaultValue) {
        return CgroupSubsystemController.getLongValue(this.unified, file, CgroupV2SubsystemController::convertStringToLong, defaultValue);
    }

    private long getLongVal(String file) {
        return this.getLongVal(file, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CgroupSubsystem getInstance(CgroupInfo anyController) {
        if (INSTANCE != null) return INSTANCE;
        CgroupV2SubsystemController unified = new CgroupV2SubsystemController(anyController.getMountPoint(), anyController.getCgroupPath());
        CgroupV2Subsystem tmpCgroupSystem = new CgroupV2Subsystem(unified);
        Class<CgroupV2Subsystem> clazz = CgroupV2Subsystem.class;
        synchronized (CgroupV2Subsystem.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = tmpCgroupSystem;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public String getProvider() {
        return PROVIDER_NAME;
    }

    @Override
    public long getCpuUsage() {
        long micros = CgroupV2SubsystemController.getLongEntry(this.unified, "cpu.stat", "usage_usec");
        if (micros < 0L) {
            return micros;
        }
        return TimeUnit.MICROSECONDS.toNanos(micros);
    }

    @Override
    public long[] getPerCpuUsage() {
        return LONG_ARRAY_NOT_SUPPORTED;
    }

    @Override
    public long getCpuUserUsage() {
        long micros = CgroupV2SubsystemController.getLongEntry(this.unified, "cpu.stat", "user_usec");
        if (micros < 0L) {
            return micros;
        }
        return TimeUnit.MICROSECONDS.toNanos(micros);
    }

    @Override
    public long getCpuSystemUsage() {
        long micros = CgroupV2SubsystemController.getLongEntry(this.unified, "cpu.stat", "system_usec");
        if (micros < 0L) {
            return micros;
        }
        return TimeUnit.MICROSECONDS.toNanos(micros);
    }

    @Override
    public long getCpuPeriod() {
        return this.getFromCpuMax(1);
    }

    @Override
    public long getCpuQuota() {
        return this.getFromCpuMax(0);
    }

    private long getFromCpuMax(int tokenIdx) {
        String cpuMaxRaw = CgroupSubsystemController.getStringValue(this.unified, "cpu.max");
        if (cpuMaxRaw == null) {
            return -1L;
        }
        String[] tokens = cpuMaxRaw.split(" ");
        if (tokens.length != 2) {
            return -1L;
        }
        String quota = tokens[tokenIdx];
        return CgroupSubsystem.limitFromString(quota);
    }

    @Override
    public long getCpuShares() {
        int distance_upper;
        long sharesRaw = this.getLongVal("cpu.weight");
        if (sharesRaw == 100L || sharesRaw <= 0L) {
            return -1L;
        }
        int shares = (int)sharesRaw;
        int x = 262142 * shares - 1;
        double frac = (double)x / 9999.0;
        if ((x = (int)frac + 2) <= 1024) {
            return 1024L;
        }
        int f = x / 1024;
        int lower_multiple = f * 1024;
        int upper_multiple = (f + 1) * 1024;
        int distance_lower = Math.max(lower_multiple, x) - Math.min(lower_multiple, x);
        x = distance_lower <= (distance_upper = Math.max(upper_multiple, x) - Math.min(upper_multiple, x)) ? lower_multiple : upper_multiple;
        return x;
    }

    @Override
    public long getCpuNumPeriods() {
        return CgroupV2SubsystemController.getLongEntry(this.unified, "cpu.stat", "nr_periods");
    }

    @Override
    public long getCpuNumThrottled() {
        return CgroupV2SubsystemController.getLongEntry(this.unified, "cpu.stat", "nr_throttled");
    }

    @Override
    public long getCpuThrottledTime() {
        long micros = CgroupV2SubsystemController.getLongEntry(this.unified, "cpu.stat", "throttled_usec");
        if (micros < 0L) {
            return micros;
        }
        return TimeUnit.MICROSECONDS.toNanos(micros);
    }

    @Override
    public long getEffectiveCpuCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int[] getCpuSetCpus() {
        String cpuSetVal = CgroupSubsystemController.getStringValue(this.unified, "cpuset.cpus");
        return this.getCpuSet(cpuSetVal);
    }

    @Override
    public int[] getEffectiveCpuSetCpus() {
        String effCpuSetVal = CgroupSubsystemController.getStringValue(this.unified, "cpuset.cpus.effective");
        return this.getCpuSet(effCpuSetVal);
    }

    @Override
    public int[] getCpuSetMems() {
        String cpuSetMems = CgroupSubsystemController.getStringValue(this.unified, "cpuset.mems");
        return this.getCpuSet(cpuSetMems);
    }

    @Override
    public int[] getEffectiveCpuSetMems() {
        String effCpuSetMems = CgroupSubsystemController.getStringValue(this.unified, "cpuset.mems.effective");
        return this.getCpuSet(effCpuSetMems);
    }

    private int[] getCpuSet(String cpuSetVal) {
        if (cpuSetVal == null || EMPTY_STR.equals(cpuSetVal)) {
            return INT_ARRAY_UNAVAILABLE;
        }
        return CgroupSubsystemController.stringRangeToIntArray(cpuSetVal);
    }

    @Override
    public long getMemoryFailCount() {
        return CgroupV2SubsystemController.getLongEntry(this.unified, "memory.events", "max");
    }

    @Override
    public long getMemoryLimit() {
        String strVal = CgroupSubsystemController.getStringValue(this.unified, "memory.max");
        return CgroupSubsystem.limitFromString(strVal);
    }

    @Override
    public long getMemoryUsage() {
        return this.getLongVal("memory.current");
    }

    @Override
    public long getTcpMemoryUsage() {
        return CgroupV2SubsystemController.getLongEntry(this.unified, "memory.stat", "sock");
    }

    @Override
    public long getMemoryAndSwapLimit() {
        String strVal = CgroupSubsystemController.getStringValue(this.unified, "memory.swap.max");
        if (strVal == null) {
            return this.getMemoryLimit();
        }
        long swapLimit = CgroupSubsystem.limitFromString(strVal);
        if (swapLimit >= 0L) {
            long memoryLimit = this.getMemoryLimit();
            assert (memoryLimit >= 0L);
            return memoryLimit + swapLimit;
        }
        return swapLimit;
    }

    @Override
    public long getMemoryAndSwapUsage() {
        long memoryUsage = this.getMemoryUsage();
        if (memoryUsage >= 0L) {
            long swapUsage = this.getLongVal("memory.swap.current", 0L);
            return memoryUsage + swapUsage;
        }
        return memoryUsage;
    }

    @Override
    public long getMemorySoftLimit() {
        String softLimitStr = CgroupSubsystemController.getStringValue(this.unified, "memory.low");
        return CgroupSubsystem.limitFromString(softLimitStr);
    }

    @Override
    public long getPidsMax() {
        String pidsMaxStr = CgroupSubsystemController.getStringValue(this.unified, "pids.max");
        return CgroupSubsystem.limitFromString(pidsMaxStr);
    }

    @Override
    public long getPidsCurrent() {
        return this.getLongVal("pids.current");
    }

    @Override
    public long getBlkIOServiceCount() {
        return this.sumTokensIOStat(CgroupV2Subsystem::lineToRandWIOs);
    }

    @Override
    public long getBlkIOServiced() {
        return this.sumTokensIOStat(CgroupV2Subsystem::lineToRBytesAndWBytesIO);
    }

    private long sumTokensIOStat(Function<String, Long> mapFunc) {
        try {
            long sum = 0L;
            for (String line : CgroupUtil.readAllLinesPrivileged(Paths.get(this.unified.path(), "io.stat"))) {
                sum += mapFunc.apply(line).longValue();
            }
            return sum;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private static String[] getRWIOMatchTokenNames() {
        return new String[]{"rios", "wios"};
    }

    private static String[] getRWBytesIOMatchTokenNames() {
        return new String[]{"rbytes", "wbytes"};
    }

    public static Long lineToRandWIOs(String line) {
        String[] matchNames = CgroupV2Subsystem.getRWIOMatchTokenNames();
        return CgroupV2Subsystem.ioStatLineToLong(line, matchNames);
    }

    public static Long lineToRBytesAndWBytesIO(String line) {
        String[] matchNames = CgroupV2Subsystem.getRWBytesIOMatchTokenNames();
        return CgroupV2Subsystem.ioStatLineToLong(line, matchNames);
    }

    private static Long ioStatLineToLong(String line, String[] matchNames) {
        if (line == null || EMPTY_STR.equals(line)) {
            return 0L;
        }
        String[] tokens = line.split(" ");
        long retval = 0L;
        for (String t : tokens) {
            String[] valKeys = t.split("=");
            if (valKeys.length != 2) continue;
            for (String match : matchNames) {
                if (!match.equals(valKeys[0])) continue;
                retval += CgroupV2Subsystem.longOrZero(valKeys[1]);
            }
        }
        return retval;
    }

    private static long longOrZero(String val) {
        long lVal = 0L;
        try {
            lVal = Long.parseLong(val);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return lVal;
    }

    static {
        LONG_ARRAY_NOT_SUPPORTED = null;
        INT_ARRAY_UNAVAILABLE = null;
        EMPTY_STR = "";
    }
}

