/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.code.CodeInfoImpl;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.CodeInfoTether;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.code.SimpleCodeInfoQueryResult;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.code.UntetheredCodeInfoAccess;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class CodeInfoAccess {
    private CodeInfoAccess() {
    }

    @Fold
    static boolean haveAssertions() {
        return RuntimeAssertionsSupport.singleton().desiredAssertionStatus(CodeInfoAccess.class);
    }

    @Uninterruptible(reason="The handle should only be accessed from uninterruptible code to prevent that the GC frees the CodeInfo.", callerMustBe=true)
    public static Object acquireTether(UntetheredCodeInfo info) {
        Object tether = UntetheredCodeInfoAccess.getTetherUnsafe(info);
        assert (VMOperation.isGCInProgress() || ((CodeInfoTether)tether).incrementCount() > 0);
        return tether;
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    @NeverInline(value="Prevent elimination of object reference in caller.")
    public static void releaseTether(UntetheredCodeInfo info, Object tether) {
        assert (VMOperation.isGCInProgress() || UntetheredCodeInfoAccess.getTetherUnsafe(info) == null || UntetheredCodeInfoAccess.getTetherUnsafe(info) == tether);
        assert (VMOperation.isGCInProgress() || ((CodeInfoTether)tether).decrementCount() >= 0);
    }

    @Uninterruptible(reason="Called during teardown.", callerMustBe=true)
    @NeverInline(value="Prevent elimination of object reference in caller.")
    public static void releaseTetherUnsafe(UntetheredCodeInfo info, Object tether) {
        assert (VMOperation.isGCInProgress() || ((CodeInfoTether)tether).decrementCount() >= 0);
    }

    @Uninterruptible(reason="Should be called from the same method as acquireTether.", callerMustBe=true)
    public static CodeInfo convert(UntetheredCodeInfo untetheredInfo, Object tether) {
        assert (UntetheredCodeInfoAccess.getTetherUnsafe(untetheredInfo) == null || UntetheredCodeInfoAccess.getTetherUnsafe(untetheredInfo) == tether);
        return CodeInfoAccess.convert(untetheredInfo);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static CodeInfo convert(UntetheredCodeInfo untetheredInfo) {
        assert (CodeInfoAccess.isValid(untetheredInfo));
        return (CodeInfo)untetheredInfo;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isValid(UntetheredCodeInfo info) {
        return SubstrateUtil.HOSTED || !CodeInfoAccess.haveAssertions() || VMOperation.isGCInProgress() || UntetheredCodeInfoAccess.getTetherUnsafe(info) == null || ((CodeInfoTether)UntetheredCodeInfoAccess.getTetherUnsafe(info)).getCount() > 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setState(CodeInfo info, int state) {
        assert (CodeInfoAccess.getState(info) < state);
        CodeInfoAccess.cast(info).setState(state);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getState(CodeInfo info) {
        return CodeInfoAccess.cast(info).getState();
    }

    public static String stateToString(int codeInfoState) {
        switch (codeInfoState) {
            case 0: {
                return "created";
            }
            case 1: {
                return "code constants live";
            }
            case 2: {
                return "non-entrant";
            }
            case 3: {
                return "ready for invalidation";
            }
            case 4: {
                return "partially freed";
            }
            case 5: {
                return "unreachable";
            }
            case 6: {
                return "invalid (freed)";
            }
        }
        return "invalid state";
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isAlive(CodeInfo info) {
        return CodeInfoAccess.isAliveState(CodeInfoAccess.cast(info).getState());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isAliveState(int state) {
        return state == 1 || state == 2;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static CodePointer getCodeStart(CodeInfo info) {
        return CodeInfoAccess.cast(info).getCodeStart();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getCodeSize(CodeInfo info) {
        return CodeInfoAccess.cast(info).getCodeSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getDataSize(CodeInfo info) {
        return CodeInfoAccess.cast(info).getDataSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getDataOffset(CodeInfo info) {
        return CodeInfoAccess.cast(info).getDataOffset();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getCodeAndDataMemorySize(CodeInfo info) {
        return CodeInfoAccess.cast(info).getCodeAndDataMemorySize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getNativeMetadataSize(CodeInfo info) {
        CodeInfoImpl impl = CodeInfoAccess.cast(info);
        UnsignedWord size = SizeOf.unsigned(CodeInfo.class);
        if (!impl.getAllObjectsAreInImageHeap()) {
            size = size.add(NonmovableArrays.byteSizeOf(impl.getObjectFields())).add(NonmovableArrays.byteSizeOf(impl.getCodeInfoIndex())).add(NonmovableArrays.byteSizeOf(impl.getCodeInfoEncodings())).add(NonmovableArrays.byteSizeOf(impl.getStackReferenceMapEncoding())).add(NonmovableArrays.byteSizeOf(impl.getFrameInfoEncodings())).add(NonmovableArrays.byteSizeOf(impl.getFrameInfoObjectConstants())).add(NonmovableArrays.byteSizeOf(impl.getFrameInfoSourceClasses())).add(NonmovableArrays.byteSizeOf(impl.getFrameInfoSourceMethodNames())).add(NonmovableArrays.byteSizeOf(impl.getDeoptimizationStartOffsets())).add(NonmovableArrays.byteSizeOf(impl.getDeoptimizationEncodings())).add(NonmovableArrays.byteSizeOf(impl.getDeoptimizationObjectConstants())).add(NonmovableArrays.byteSizeOf(impl.getCodeConstantsReferenceMapEncoding()));
        }
        return size;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean contains(CodeInfo info, CodePointer ip) {
        CodeInfoImpl impl = CodeInfoAccess.cast(info);
        return ((UnsignedWord)ip).subtract((UnsignedWord)impl.getCodeStart()).belowThan(impl.getCodeSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long relativeIP(CodeInfo info, CodePointer ip) {
        assert (CodeInfoAccess.contains(info, ip));
        return ((UnsignedWord)ip).subtract((UnsignedWord)CodeInfoAccess.cast(info).getCodeStart()).rawValue();
    }

    public static CodePointer absoluteIP(CodeInfo info, long relativeIP) {
        return (CodePointer)((UnsignedWord)CodeInfoAccess.cast(info).getCodeStart()).add(WordFactory.unsigned((long)relativeIP));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static <T> T getObjectField(CodeInfo info, int index) {
        return (T)NonmovableArrays.getObject(CodeInfoAccess.cast(info).getObjectFields(), index);
    }

    public static String getName(CodeInfo info) {
        return (String)CodeInfoAccess.getObjectField(info, 1);
    }

    public static long lookupDeoptimizationEntrypoint(CodeInfo info, long method, long encodedBci, CodeInfoQueryResult codeInfo) {
        return CodeInfoDecoder.lookupDeoptimizationEntrypoint(info, method, encodedBci, codeInfo);
    }

    public static long lookupTotalFrameSize(CodeInfo info, long ip) {
        SimpleCodeInfoQueryResult codeInfoQueryResult = UnsafeStackValue.get(SimpleCodeInfoQueryResult.class);
        CodeInfoAccess.lookupCodeInfo(info, ip, codeInfoQueryResult);
        return CodeInfoQueryResult.getTotalFrameSize(codeInfoQueryResult.getEncodedFrameSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static NonmovableArray<Byte> getStackReferenceMapEncoding(CodeInfo info) {
        return CodeInfoAccess.cast(info).getStackReferenceMapEncoding();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long lookupStackReferenceMapIndex(CodeInfo info, long ip) {
        return CodeInfoDecoder.lookupStackReferenceMapIndex(info, ip);
    }

    public static void lookupCodeInfo(CodeInfo info, long ip, CodeInfoQueryResult codeInfoQueryResult) {
        CodeInfoDecoder.lookupCodeInfo(info, ip, codeInfoQueryResult);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void lookupCodeInfo(CodeInfo info, long ip, SimpleCodeInfoQueryResult codeInfoQueryResult) {
        CodeInfoDecoder.lookupCodeInfo(info, ip, codeInfoQueryResult);
    }

    @Uninterruptible(reason="Nonmovable object arrays are not visible to GC until installed.")
    public static void setFrameInfo(CodeInfo info, NonmovableArray<Byte> encodings) {
        CodeInfoImpl impl = CodeInfoAccess.cast(info);
        impl.setFrameInfoEncodings(encodings);
    }

    public static void setCodeInfo(CodeInfo info, NonmovableArray<Byte> index, NonmovableArray<Byte> encodings, NonmovableArray<Byte> referenceMapEncoding) {
        CodeInfoImpl impl = CodeInfoAccess.cast(info);
        impl.setCodeInfoIndex(index);
        impl.setCodeInfoEncodings(encodings);
        impl.setStackReferenceMapEncoding(referenceMapEncoding);
    }

    @Uninterruptible(reason="Nonmovable object arrays are not visible to GC until installed.")
    public static void setEncodings(CodeInfo info, NonmovableObjectArray<Object> objectConstants, NonmovableObjectArray<Class<?>> sourceClasses, NonmovableObjectArray<String> sourceMethodNames) {
        CodeInfoImpl impl = CodeInfoAccess.cast(info);
        impl.setFrameInfoObjectConstants(objectConstants);
        impl.setFrameInfoSourceClasses(sourceClasses);
        impl.setFrameInfoSourceMethodNames(sourceMethodNames);
        if (!SubstrateUtil.HOSTED) {
            Heap.getHeap().getRuntimeCodeInfoGCSupport().registerFrameMetadata(impl);
        }
    }

    public static Log log(CodeInfo info, Log log) {
        return info.isNull() ? log.string("null") : log.string("CodeInfo@").hex((WordBase)info);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getTier(CodeInfo info) {
        return CodeInfoAccess.cast(info).getTier();
    }

    static NonmovableArray<Integer> getDeoptimizationStartOffsets(CodeInfo info) {
        return CodeInfoAccess.cast(info).getDeoptimizationStartOffsets();
    }

    static NonmovableArray<Byte> getDeoptimizationEncodings(CodeInfo info) {
        return CodeInfoAccess.cast(info).getDeoptimizationEncodings();
    }

    static NonmovableObjectArray<Object> getDeoptimizationObjectConstants(CodeInfo info) {
        return CodeInfoAccess.cast(info).getDeoptimizationObjectConstants();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static CodePointer getCodeEnd(CodeInfo info) {
        CodeInfoImpl impl = CodeInfoAccess.cast(info);
        return (CodePointer)((UnsignedWord)impl.getCodeStart()).add(impl.getCodeSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static NonmovableArray<Byte> getCodeInfoIndex(CodeInfo info) {
        return CodeInfoAccess.cast(info).getCodeInfoIndex();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static NonmovableArray<Byte> getCodeInfoEncodings(CodeInfo info) {
        return CodeInfoAccess.cast(info).getCodeInfoEncodings();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static NonmovableArray<Byte> getFrameInfoEncodings(CodeInfo info) {
        return CodeInfoAccess.cast(info).getFrameInfoEncodings();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static NonmovableObjectArray<Object> getFrameInfoObjectConstants(CodeInfo info) {
        return CodeInfoAccess.cast(info).getFrameInfoObjectConstants();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static NonmovableObjectArray<Class<?>> getFrameInfoSourceClasses(CodeInfo info) {
        return CodeInfoAccess.cast(info).getFrameInfoSourceClasses();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isAOTImageCodeSlow(CodeInfo info) {
        return info == CodeInfoTable.getImageCodeInfo();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static NonmovableObjectArray<String> getFrameInfoSourceMethodNames(CodeInfo info) {
        return CodeInfoAccess.cast(info).getFrameInfoSourceMethodNames();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static CodeInfoImpl cast(UntetheredCodeInfo info) {
        assert (CodeInfoAccess.isValid(info));
        return (CodeInfoImpl)info;
    }

    public static void printCodeInfo(Log log, CodeInfo info, boolean allowJavaHeapAccess) {
        String name = null;
        HasInstalledCode hasInstalledCode = HasInstalledCode.Unknown;
        SubstrateInstalledCode installedCode = null;
        if (allowJavaHeapAccess) {
            name = CodeInfoAccess.getName(info);
            installedCode = RuntimeCodeInfoAccess.getInstalledCode(info);
            hasInstalledCode = installedCode == null ? HasInstalledCode.No : HasInstalledCode.Yes;
        }
        CodeInfoAccess.printCodeInfo(log, info, CodeInfoAccess.getState(info), name, CodeInfoAccess.getCodeStart(info), CodeInfoAccess.getCodeEnd(info), hasInstalledCode, installedCode);
    }

    public static void printCodeInfo(Log log, UntetheredCodeInfo info, int state, String name, CodePointer codeStart, CodePointer codeEnd, HasInstalledCode hasInstalledCode, SubstrateInstalledCode installedCode) {
        long installedCodeAddress = 0L;
        long installedCodeEntryPoint = 0L;
        if (installedCode != null) {
            assert (hasInstalledCode == HasInstalledCode.Yes);
            installedCodeAddress = installedCode.getAddress();
            installedCodeEntryPoint = installedCode.getEntryPoint();
        }
        CodeInfoAccess.printCodeInfo(log, info, state, name, codeStart, codeEnd, hasInstalledCode, installedCodeAddress, installedCodeEntryPoint);
    }

    public static void printCodeInfo(Log log, UntetheredCodeInfo codeInfo, int state, String name, CodePointer codeStart, CodePointer codeEnd, HasInstalledCode hasInstalledCode, long installedCodeAddress, long installedCodeEntryPoint) {
        log.string("CodeInfo (").zhex((WordBase)codeInfo).string(" - ").zhex((WordBase)((UnsignedWord)codeInfo).add(CodeInfoAccess.getSizeOfCodeInfo()).subtract(1)).string("), ").string(CodeInfoAccess.stateToString(state));
        if (name != null) {
            log.string(" - ").string(name);
        }
        log.string(", ip: (").zhex((WordBase)codeStart).string(" - ").zhex((WordBase)codeEnd).string(")");
        switch (hasInstalledCode) {
            case Yes: {
                log.string(", installedCode: (address: ").zhex(installedCodeAddress).string(", entryPoint: ").zhex(installedCodeEntryPoint).string(")");
                break;
            }
            case No: {
                log.string(", installedCode: null.");
                break;
            }
            case Unknown: {
                break;
            }
            default: {
                throw VMError.shouldNotReachHere("Unexpected value for HasInstalledCode");
            }
        }
    }

    @Fold
    public static UnsignedWord getSizeOfCodeInfo() {
        return SizeOf.unsigned(CodeInfoImpl.class);
    }

    public static enum HasInstalledCode {
        Yes,
        No,
        Unknown;

    }
}

