/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class BuildPhaseProvider {
    private boolean analysisStarted;
    private boolean analysisFinished;
    private boolean hostedUniverseBuilt;
    private boolean compilationFinished;

    public static void init() {
        ImageSingletons.add(BuildPhaseProvider.class, (Object)new BuildPhaseProvider());
    }

    static BuildPhaseProvider singleton() {
        return (BuildPhaseProvider)ImageSingletons.lookup(BuildPhaseProvider.class);
    }

    BuildPhaseProvider() {
    }

    public static void markAnalysisStarted() {
        BuildPhaseProvider.singleton().analysisStarted = true;
    }

    public static boolean isAnalysisStarted() {
        return ImageSingletons.contains(BuildPhaseProvider.class) && BuildPhaseProvider.singleton().analysisStarted;
    }

    public static void markAnalysisFinished() {
        BuildPhaseProvider.singleton().analysisFinished = true;
    }

    public static boolean isAnalysisFinished() {
        return ImageSingletons.contains(BuildPhaseProvider.class) && BuildPhaseProvider.singleton().analysisFinished;
    }

    public static void markHostedUniverseBuilt() {
        BuildPhaseProvider.singleton().hostedUniverseBuilt = true;
    }

    public static boolean isHostedUniverseBuilt() {
        return ImageSingletons.contains(BuildPhaseProvider.class) && BuildPhaseProvider.singleton().hostedUniverseBuilt;
    }

    public static void markCompilationFinished() {
        BuildPhaseProvider.singleton().compilationFinished = true;
    }

    public static boolean isCompilationFinished() {
        return ImageSingletons.contains(BuildPhaseProvider.class) && BuildPhaseProvider.singleton().compilationFinished;
    }
}

