/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.NeverInlineTrivial;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import com.oracle.svm.hosted.annotation.SubstrateAnnotationExtractor;
import com.oracle.svm.hosted.code.FactoryMethodSupport;
import com.oracle.svm.hosted.code.NonBytecodeMethod;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import com.oracle.svm.util.ReflectionUtil;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.nativeimage.ImageSingletons;

public final class FactoryMethod
extends NonBytecodeMethod {
    private final ResolvedJavaMethod targetConstructor;
    private final boolean throwAllocatedObject;
    private static final AnnotationValue[] INJECTED_ANNOTATIONS = SubstrateAnnotationExtractor.prepareInjectedAnnotations(ReflectionUtil.lookupMethod(FactoryMethod.class, (String)"annotationHolder", (Class[])new Class[0]).getAnnotation(NeverInlineTrivial.class));

    FactoryMethod(String name, ResolvedJavaMethod targetConstructor, ResolvedJavaType declaringClass, Signature signature, ConstantPool constantPool, boolean throwAllocatedObject) {
        super(name, true, declaringClass, signature, constantPool);
        this.targetConstructor = targetConstructor;
        this.throwAllocatedObject = throwAllocatedObject;
        assert (targetConstructor.isConstructor());
        assert (!(targetConstructor instanceof AnalysisMethod) && !(targetConstructor instanceof HostedMethod));
    }

    @NeverInlineTrivial(value="FactoryMethod")
    private static void annotationHolder() {
    }

    @Override
    public AnnotationValue[] getInjectedAnnotations() {
        return INJECTED_ANNOTATIONS;
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        FactoryMethodSupport support = (FactoryMethodSupport)ImageSingletons.lookup(FactoryMethodSupport.class);
        UniverseMetaAccess metaAccess = (UniverseMetaAccess)providers.getMetaAccess();
        ResolvedJavaMethod universeTargetConstructor = this.lookupMethodInUniverse(metaAccess, this.targetConstructor);
        HostedGraphKit kit = new HostedGraphKit(debug, providers, method, purpose);
        AbstractNewObjectNode newInstance = support.createNewInstance(kit, universeTargetConstructor.getDeclaringClass(), true);
        ValueNode[] originalArgs = kit.loadArguments(method.toParameterTypes()).toArray(ValueNode.EMPTY_ARRAY);
        ValueNode[] invokeArgs = new ValueNode[originalArgs.length + 1];
        invokeArgs[0] = newInstance;
        System.arraycopy(originalArgs, 0, invokeArgs, 1, originalArgs.length);
        kit.createInvokeWithExceptionAndUnwind(universeTargetConstructor, CallTargetNode.InvokeKind.Special, kit.getFrameState(), kit.bci(), invokeArgs);
        if (this.throwAllocatedObject) {
            kit.append((ValueNode)new UnwindNode((ValueNode)newInstance));
        } else {
            kit.createReturn((ValueNode)newInstance, newInstance.getStackKind());
        }
        return kit.finalizeGraph();
    }

    private ResolvedJavaMethod lookupMethodInUniverse(UniverseMetaAccess metaAccess, ResolvedJavaMethod method) {
        ResolvedJavaMethod universeMethod = method;
        MetaAccessProvider wrappedMetaAccess = metaAccess.getWrapped();
        if (wrappedMetaAccess instanceof UniverseMetaAccess) {
            universeMethod = this.lookupMethodInUniverse((UniverseMetaAccess)wrappedMetaAccess, universeMethod);
        }
        return metaAccess.getUniverse().lookup((JavaMethod)universeMethod);
    }
}

