/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.annotation.AnnotationSubstitutionType;
import com.oracle.svm.hosted.annotation.AnnotationSupport;
import com.oracle.svm.hosted.annotation.CustomSubstitutionField;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import sun.reflect.annotation.TypeNotPresentExceptionProxy;

public class AnnotationSubstitutionField
extends CustomSubstitutionField {
    private final ResolvedJavaMethod accessorMethod;
    private final Map<JavaConstant, JavaConstant> valueCache;
    private final SnippetReflectionProvider snippetReflection;
    private final MetaAccessProvider metaAccess;

    public AnnotationSubstitutionField(AnnotationSubstitutionType declaringClass, ResolvedJavaMethod accessorMethod, SnippetReflectionProvider snippetReflection, MetaAccessProvider metaAccess) {
        super(declaringClass);
        this.accessorMethod = accessorMethod;
        this.snippetReflection = snippetReflection;
        this.valueCache = Collections.synchronizedMap(new HashMap());
        this.metaAccess = metaAccess;
    }

    public String getName() {
        return this.accessorMethod.getName();
    }

    public JavaType getType() {
        JavaType actualType = this.accessorMethod.getSignature().getReturnType(this.accessorMethod.getDeclaringClass());
        if (AnnotationSupport.isClassType(actualType, this.metaAccess)) {
            return this.metaAccess.lookupJavaType(Object.class);
        }
        return actualType;
    }

    @Override
    public JavaConstant readValue(MetaAccessProvider suppliedMetaAccess, ClassInitializationSupport classInitializationSupport, JavaConstant receiver) {
        JavaConstant result = this.valueCache.get(receiver);
        if (result == null) {
            Object annotationFieldValue;
            try {
                Proxy proxy = (Proxy)this.snippetReflection.asObject(Proxy.class, receiver);
                Class<?> annotationInterface = AnnotationSupport.findAnnotationInterfaceTypeForMarkedAnnotationType(proxy.getClass());
                annotationFieldValue = ReflectionUtil.lookupMethod(annotationInterface, (String)this.accessorMethod.getName(), (Class[])new Class[0]).invoke((Object)proxy, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof TypeNotPresentException) {
                    TypeNotPresentException tnpe = (TypeNotPresentException)cause;
                    annotationFieldValue = new TypeNotPresentExceptionProxy(tnpe.typeName(), new NoClassDefFoundError(tnpe.typeName()));
                }
                throw VMError.shouldNotReachHere(ex);
            }
            result = this.snippetReflection.forBoxed(this.getJavaKind(), annotationFieldValue);
            this.valueCache.put(receiver, result);
        }
        return result;
    }

    @Override
    public boolean isValueAvailableBeforeAnalysis() {
        return true;
    }

    @Override
    public boolean injectFinalForRuntimeCompilation() {
        return true;
    }

    public String toString() {
        return "AnnotationField<" + this.format("%h.%n") + ">";
    }
}

