/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.classinitialization.ClassInitializationInfo;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.ExceptionSynthesizer;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.GraalError;

public class DynamicHubInitializer {
    private final BigBang bb;
    private final SVMHost hostVM;
    private final AnalysisMetaAccess metaAccess;
    private final ConstantReflectionProvider constantReflection;
    private final Map<InterfacesEncodingKey, DynamicHub[]> interfacesEncodings;
    private final Field dynamicHubClassInitializationInfoField;
    private final Field dynamicHubArrayHubField;
    private final Field dynamicHubInterfacesEncodingField;
    private final Field dynamicHubAnnotationsEnumConstantsReferenceField;
    private static final Method getSignature = ReflectionUtil.lookupMethod(Class.class, (String)"getGenericSignature0", (Class[])new Class[0]);

    public DynamicHubInitializer(BigBang bb) {
        this.bb = bb;
        this.metaAccess = bb.getMetaAccess();
        this.hostVM = (SVMHost)bb.getHostVM();
        this.constantReflection = bb.getConstantReflectionProvider();
        this.interfacesEncodings = new ConcurrentHashMap<InterfacesEncodingKey, DynamicHub[]>();
        this.dynamicHubClassInitializationInfoField = ReflectionUtil.lookupField(DynamicHub.class, (String)"classInitializationInfo");
        this.dynamicHubArrayHubField = ReflectionUtil.lookupField(DynamicHub.class, (String)"arrayHub");
        this.dynamicHubInterfacesEncodingField = ReflectionUtil.lookupField(DynamicHub.class, (String)"interfacesEncoding");
        this.dynamicHubAnnotationsEnumConstantsReferenceField = ReflectionUtil.lookupField(DynamicHub.class, (String)"enumConstantsReference");
    }

    public void initializeMetaData(ImageHeapScanner heapScanner, AnalysisType type) {
        assert (type.isReachable()) : "Type " + type.toJavaName(true) + " is not marked as reachable.";
        AnalysisError.guarantee((!BuildPhaseProvider.isAnalysisFinished() ? 1 : 0) != 0, (String)"Initializing type metadata after analysis for %s.", (Object[])new Object[]{type.toJavaName(true)});
        Class javaClass = type.getJavaClass();
        heapScanner.rescanObject((Object)javaClass.getPackage());
        DynamicHub hub = this.hostVM.dynamicHub((ResolvedJavaType)type);
        heapScanner.rescanObject((Object)hub, ObjectScanner.OtherReason.HUB);
        this.buildClassInitializationInfo(heapScanner, type, hub);
        DynamicHubInitializer.fillSignature(type, hub);
        if (type.getJavaKind() == JavaKind.Object) {
            if (type.isArray()) {
                AnalysisError.guarantee((hub.getComponentHub().getArrayHub() == null ? 1 : 0) != 0, (String)"Array hub already initialized for %s.", (Object[])new Object[]{type.getComponentType().toJavaName(true)});
                hub.getComponentHub().setArrayHub(hub);
                heapScanner.rescanField((Object)hub.getComponentHub(), this.dynamicHubArrayHubField);
            }
            this.fillInterfaces(type, hub);
            heapScanner.rescanField((Object)hub, this.dynamicHubInterfacesEncodingField);
            if (type.isEnum()) {
                AnalysisError.guarantee((boolean)hub.shouldInitEnumConstants(), (String)"Enum constants already initialized for %s.", (Object[])new Object[]{type.toJavaName(true)});
                if (this.hostVM.getClassInitializationSupport().shouldInitializeAtRuntime((ResolvedJavaType)type)) {
                    hub.initEnumConstantsAtRuntime(javaClass);
                } else {
                    hub.initEnumConstants(this.retrieveEnumConstantArray(type, javaClass));
                }
                heapScanner.rescanField((Object)hub, this.dynamicHubAnnotationsEnumConstantsReferenceField);
            }
        }
    }

    private Enum<?>[] retrieveEnumConstantArray(AnalysisType type, Class<?> javaClass) {
        Enum[] enumConstants;
        AnalysisField found = null;
        for (ResolvedJavaField javaField : type.getStaticFields()) {
            AnalysisField f = (AnalysisField)javaField;
            if (!f.getName().endsWith("$VALUES")) continue;
            if (found != null) {
                found = null;
                break;
            }
            found = f;
        }
        if (found == null) {
            enumConstants = (Enum[])javaClass.getEnumConstants();
        } else {
            enumConstants = (Enum[])SubstrateObjectConstant.asObject((Constant)this.constantReflection.readFieldValue(found, null));
            assert (enumConstants != null);
        }
        return enumConstants;
    }

    private void buildClassInitializationInfo(ImageHeapScanner heapScanner, AnalysisType type, DynamicHub hub) {
        ClassInitializationInfo info;
        AnalysisError.guarantee((hub.getClassInitializationInfo() == null ? 1 : 0) != 0, (String)"Class initialization info already computed for %s.", (Object[])new Object[]{type.toJavaName(true)});
        if (this.hostVM.getClassInitializationSupport().shouldInitializeAtRuntime((ResolvedJavaType)type)) {
            info = this.buildRuntimeInitializationInfo(type);
        } else {
            assert (type.isInitialized());
            info = type.getClassInitializer() == null ? ClassInitializationInfo.NO_INITIALIZER_INFO_SINGLETON : ClassInitializationInfo.INITIALIZED_INFO_SINGLETON;
        }
        hub.setClassInitializationInfo(info);
        heapScanner.rescanField((Object)hub, this.dynamicHubClassInitializationInfoField);
    }

    private ClassInitializationInfo buildRuntimeInitializationInfo(AnalysisType type) {
        assert (!type.isInitialized());
        try {
            type.link();
        }
        catch (VerifyError e) {
            AnalysisMethod throwVerifyError = this.metaAccess.lookupJavaMethod((Executable)ExceptionSynthesizer.throwExceptionMethod(VerifyError.class));
            this.bb.addRootMethod(throwVerifyError, true);
            return new ClassInitializationInfo(new MethodPointer((ResolvedJavaMethod)throwVerifyError));
        }
        catch (Throwable t) {
            return ClassInitializationInfo.FAILED_INFO_SINGLETON;
        }
        assert (type.isLinked());
        MethodPointer classInitializerFunction = null;
        AnalysisMethod classInitializer = type.getClassInitializer();
        if (classInitializer != null) {
            assert (classInitializer.getCode() != null);
            this.bb.addRootMethod(classInitializer, true);
            classInitializerFunction = new MethodPointer((ResolvedJavaMethod)classInitializer);
        }
        return new ClassInitializationInfo(classInitializerFunction);
    }

    private static void fillSignature(AnalysisType type, DynamicHub hub) {
        String signature;
        AnalysisError.guarantee((hub.getSignature() == null ? 1 : 0) != 0, (String)"Signature already computed for %s.", (Object[])new Object[]{type.toJavaName(true)});
        Class javaClass = type.getJavaClass();
        try {
            signature = (String)getSignature.invoke((Object)javaClass, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere();
        }
        hub.setSignature(signature);
    }

    private void fillInterfaces(AnalysisType type, DynamicHub hub) {
        AnalysisError.guarantee((hub.getInterfacesEncoding() == null ? 1 : 0) != 0, (String)"Interfaces already computed for %s.", (Object[])new Object[]{type.toJavaName(true)});
        AnalysisType[] aInterfaces = type.getInterfaces();
        if (aInterfaces.length == 0) {
            hub.setInterfacesEncoding(null);
        } else if (aInterfaces.length == 1) {
            hub.setInterfacesEncoding(this.hostVM.dynamicHub((ResolvedJavaType)aInterfaces[0]));
        } else {
            hub.setInterfacesEncoding(this.interfacesEncodings.computeIfAbsent(new InterfacesEncodingKey(aInterfaces), InterfacesEncodingKey::createHubs));
        }
    }

    class InterfacesEncodingKey {
        final AnalysisType[] aInterfaces;

        InterfacesEncodingKey(AnalysisType[] aInterfaces) {
            this.aInterfaces = aInterfaces;
        }

        DynamicHub[] createHubs() {
            DynamicHub[] hubs = new DynamicHub[this.aInterfaces.length];
            for (int i = 0; i < hubs.length; ++i) {
                hubs[i] = DynamicHubInitializer.this.hostVM.dynamicHub((ResolvedJavaType)this.aInterfaces[i]);
            }
            return hubs;
        }

        public boolean equals(Object obj) {
            return obj instanceof InterfacesEncodingKey && Arrays.equals(this.aInterfaces, ((InterfacesEncodingKey)obj).aInterfaces);
        }

        public int hashCode() {
            return Arrays.hashCode(this.aInterfaces);
        }
    }
}

