/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.hosted.FieldsOffsetsFeature;
import com.oracle.svm.graal.hosted.RuntimeCompilationFeature;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.graph.NodeClass;

@TargetClass(value=NodeClass.class, onlyWith={RuntimeCompilationFeature.IsEnabled.class})
final class Target_org_graalvm_compiler_graph_NodeClass {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=FieldsOffsetsFeature.InputsIterationMaskRecomputation.class)
    private long inputsIteration;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=FieldsOffsetsFeature.SuccessorsIterationMaskRecomputation.class)
    private long successorIteration;
    @Alias
    private String shortName;

    Target_org_graalvm_compiler_graph_NodeClass() {
    }

    @Substitute
    @SuppressFBWarnings(value={"GC_UNRELATED_TYPES"}, justification="Class is DynamicHub")
    public static NodeClass<?> get(Class<?> clazz) {
        NodeClass nodeClass = (NodeClass)GraalSupport.get().nodeClasses.get(clazz);
        if (nodeClass == null) {
            throw VMError.shouldNotReachHere(String.format("Unknown node class: %s%n", clazz.getName()));
        }
        return nodeClass;
    }

    @Substitute
    public String shortName() {
        assert (this.shortName != null);
        return this.shortName;
    }
}

