/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util.json;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class JsonWriter
implements AutoCloseable {
    private final Writer writer;
    private int indentation = 0;

    public JsonWriter(Path path, OpenOption ... options) throws IOException {
        this(Files.newBufferedWriter(path, StandardCharsets.UTF_8, options));
    }

    public JsonWriter(Writer writer) {
        this.writer = writer;
    }

    public JsonWriter append(char c) throws IOException {
        this.writer.write(c);
        return this;
    }

    public JsonWriter append(String s) throws IOException {
        this.writer.write(s);
        return this;
    }

    public JsonWriter appendObjectStart() throws IOException {
        return this.append('{');
    }

    public JsonWriter appendObjectEnd() throws IOException {
        return this.append('}');
    }

    public JsonWriter appendArrayStart() throws IOException {
        return this.append('[');
    }

    public JsonWriter appendArrayEnd() throws IOException {
        return this.append(']');
    }

    public JsonWriter appendSeparator() throws IOException {
        return this.append(',');
    }

    public JsonWriter appendFieldSeparator() throws IOException {
        return this.append(':');
    }

    public JsonWriter appendKeyValue(String key, Object value) throws IOException {
        return this.quote(key).appendFieldSeparator().quote(value);
    }

    public void print(Map<String, Object> map) throws IOException {
        if (map.isEmpty()) {
            this.append("{}");
            return;
        }
        this.append('{');
        Iterator<String> keySetIter = map.keySet().iterator();
        while (keySetIter.hasNext()) {
            String key = keySetIter.next();
            Object value = map.get(key);
            this.quote(key).append(':');
            if (value instanceof Map) {
                this.print((Map)value);
            } else if (value instanceof List) {
                this.print((List)value);
            } else {
                this.quote(value);
            }
            if (!keySetIter.hasNext()) continue;
            this.append(',');
        }
        this.append('}');
    }

    public void print(List<String> list) throws IOException {
        this.print(list, s -> s);
    }

    public <T> void print(List<T> list, Function<T, String> mapper) throws IOException {
        if (list.isEmpty()) {
            this.append("[]");
            return;
        }
        this.append('[');
        Iterator<T> iter = list.iterator();
        while (iter.hasNext()) {
            this.quote(mapper.apply(iter.next()));
            if (!iter.hasNext()) continue;
            this.append(',');
        }
        this.append(']');
    }

    public JsonWriter quote(Object o) throws IOException {
        if (o == null) {
            return this.append("null");
        }
        if (Boolean.TRUE.equals(o)) {
            return this.append("true");
        }
        if (Boolean.FALSE.equals(o)) {
            return this.append("false");
        }
        if (o instanceof Number) {
            return this.append(o.toString());
        }
        return this.quote(o.toString());
    }

    public JsonWriter quote(String s) throws IOException {
        this.writer.write(JsonWriter.quoteString(s));
        return this;
    }

    public static String quoteString(String s) {
        if (s == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(2 + s.length() + 8);
        sb.append('\"');
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"' || c == '\\') {
                sb.append('\\');
                sb.append(c);
                continue;
            }
            if (c < '\u001f') {
                sb.append(String.format("\\u%04x", c));
                continue;
            }
            sb.append(c);
        }
        sb.append('\"');
        return sb.toString();
    }

    public JsonWriter newline() throws IOException {
        StringBuilder builder = new StringBuilder(1 + 2 * this.indentation);
        builder.append("\n");
        for (int i = 0; i < this.indentation; ++i) {
            builder.append("  ");
        }
        this.writer.write(builder.toString());
        return this;
    }

    public JsonWriter indent() {
        ++this.indentation;
        return this;
    }

    public JsonWriter unindent() {
        assert (this.indentation > 0);
        --this.indentation;
        return this;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

