/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect;

import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.reflect.Target_java_lang_reflect_RecordComponent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public interface ReflectionMetadataDecoder {
    public static final int NO_DATA = -1;

    public Field[] parseFields(DynamicHub var1, int var2, boolean var3);

    public FieldDescriptor[] parseReachableFields(DynamicHub var1, int var2);

    public Method[] parseMethods(DynamicHub var1, int var2, boolean var3);

    public MethodDescriptor[] parseReachableMethods(DynamicHub var1, int var2);

    public Constructor<?>[] parseConstructors(DynamicHub var1, int var2, boolean var3);

    public ConstructorDescriptor[] parseReachableConstructors(DynamicHub var1, int var2);

    public Class<?>[] parseClasses(int var1);

    public Target_java_lang_reflect_RecordComponent[] parseRecordComponents(DynamicHub var1, int var2);

    public Object[] parseObjects(int var1);

    public Parameter[] parseReflectParameters(Executable var1, byte[] var2);

    public Object[] parseEnclosingMethod(int var1);

    public byte[] parseByteArray(int var1);

    public boolean isHiding(int var1);

    public boolean isNegative(int var1);

    public long getMetadataByteLength();

    public static interface MetadataAccessor {
        public <T> T getObject(int var1);

        public Class<?> getClass(int var1);

        public String getString(int var1);
    }

    public static class ConstructorDescriptor
    extends ElementDescriptor {
        public final String[] parameterTypeNames;

        public ConstructorDescriptor(Class<?> declaringClass, String[] parameterTypeNames) {
            super(declaringClass);
            this.parameterTypeNames = parameterTypeNames;
        }

        public ConstructorDescriptor(Constructor<?> constructor) {
            this(constructor.getDeclaringClass(), ConstructorDescriptor.getParameterTypeNames(constructor.getParameterTypes()));
        }

        public String[] getParameterTypeNames() {
            return this.parameterTypeNames;
        }
    }

    public static class MethodDescriptor
    extends ElementDescriptor {
        public final String name;
        public final String[] parameterTypeNames;

        public MethodDescriptor(Class<?> declaringClass, String name, String[] parameterTypeNames) {
            super(declaringClass);
            this.name = name;
            this.parameterTypeNames = parameterTypeNames;
        }

        public MethodDescriptor(Method method) {
            this(method.getDeclaringClass(), method.getName(), MethodDescriptor.getParameterTypeNames(method.getParameterTypes()));
        }

        public String getName() {
            return this.name;
        }

        public String[] getParameterTypeNames() {
            return this.parameterTypeNames;
        }
    }

    public static class FieldDescriptor
    extends ElementDescriptor {
        public final String name;

        public FieldDescriptor(Class<?> declaringClass, String name) {
            super(declaringClass);
            this.name = name;
        }

        public FieldDescriptor(Field field) {
            this(field.getDeclaringClass(), field.getName());
        }

        public String getName() {
            return this.name;
        }
    }

    public static class ElementDescriptor {
        private final Class<?> declaringClass;

        public ElementDescriptor(Class<?> declaringClass) {
            this.declaringClass = declaringClass;
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        protected static String[] getParameterTypeNames(Class<?>[] parameterTypes) {
            String[] parameterTypeNames = new String[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameterTypeNames[i] = parameterTypes[i].getTypeName();
            }
            return parameterTypeNames;
        }
    }
}

