/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.jdk.JNIRegistrationSupport;
import com.oracle.svm.hosted.reflect.ReflectionDataBuilder;
import com.oracle.svm.hosted.util.CPUTypeAArch64;
import com.oracle.svm.hosted.util.CPUTypeAMD64;
import java.util.List;
import java.util.function.Supplier;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

@AutomaticallyRegisteredFeature
public class ProgressReporterFeature
implements InternalFeature {
    protected final ProgressReporter reporter = ProgressReporter.singleton();

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        this.reporter.reportStageProgress();
    }

    protected void appendGraalSuffix(ProgressReporter.DirectPrinter graalLine) {
    }

    public void createAdditionalArtifacts(BuildArtifacts artifacts) {
    }

    protected List<UserRecommendation> getRecommendations() {
        return List.of(new UserRecommendation("AWT", "Use the tracing agent to collect metadata for AWT.", ProgressReporterFeature::recommendTraceAgentForAWT), new UserRecommendation("HEAP", "Set max heap for improved and more predictable memory usage.", () -> SubstrateGCOptions.MaxHeapSize.getValue() == 0L), new UserRecommendation("CPU", "Enable more CPU features with '-march=native' for improved performance.", ProgressReporterFeature::recommendMArchNative));
    }

    private static boolean recommendMArchNative() {
        if (NativeImageOptions.MicroArchitecture.getValue() != null) {
            return false;
        }
        return switch (SubstrateUtil.getArchitectureName()) {
            case "aarch64" -> CPUTypeAArch64.nativeSupportsMoreFeaturesThanSelected();
            case "amd64" -> CPUTypeAMD64.nativeSupportsMoreFeaturesThanSelected();
            default -> false;
        };
    }

    private static boolean recommendTraceAgentForAWT() {
        if (!ImageSingletons.contains(JNIRegistrationSupport.class)) {
            return false;
        }
        if (!JNIRegistrationSupport.singleton().isRegisteredLibrary("awt")) {
            return false;
        }
        ReflectionDataBuilder dataBuilder = (ReflectionDataBuilder)ImageSingletons.lookup(RuntimeReflectionSupport.class);
        return dataBuilder.getReflectionExecutables().values().stream().anyMatch(m -> {
            String className = m.getDeclaringClass().getName();
            return className.startsWith("java.awt") || className.startsWith("sun.awt");
        });
    }

    public record UserRecommendation(String id, String description, Supplier<Boolean> isApplicable) {
        public UserRecommendation {
            assert (id.toUpperCase().equals(id) && id.length() < 5) : "id must be uppercase and have fewer than 5 chars";
            assert (description.length() < 74) : "description must have fewer than 74 chars to fit in terminal";
        }
    }
}

