/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.thread.ParkEvent;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;

public abstract class Parker {
    protected boolean isSleepEvent;

    protected Parker() {
    }

    protected abstract void reset();

    protected boolean tryFastPark() {
        return false;
    }

    protected abstract void park(boolean var1, long var2);

    protected abstract void unpark();

    static Parker acquire(boolean isSleepEvent) {
        Parker event = ParkerFactory.singleton().acquire();
        event.isSleepEvent = isSleepEvent;
        return event;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract void release();

    public static interface ParkerFactory {
        @Fold
        public static ParkerFactory singleton() {
            if (ImageSingletons.contains(ParkEvent.ParkEventFactory.class)) {
                return (ParkerFactory)ImageSingletons.lookup(ParkEvent.ParkEventFactory.class);
            }
            return (ParkerFactory)ImageSingletons.lookup(ParkerFactory.class);
        }

        public Parker acquire();
    }
}

