/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.results.StaticAnalysisResults;
import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.code.StubCallingConvention;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.CompilationInfo;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import jdk.internal.vm.annotation.ForceInline;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.JavaMethodContext;
import org.graalvm.compiler.nodes.StructuredGraph;

public final class HostedMethod
implements SharedMethod,
WrappedJavaMethod,
GraphProvider,
JavaMethodContext,
OriginalMethodProvider {
    public static final String METHOD_NAME_COLLISION_SUFFIX = "*";
    public static final String METHOD_NAME_DEOPT_SUFFIX = "**";
    public final AnalysisMethod wrapped;
    private final HostedType holder;
    private final Signature signature;
    private final ConstantPool constantPool;
    private final ExceptionHandler[] handlers;
    StaticAnalysisResults staticAnalysisResults;
    int vtableIndex = -1;
    private int codeAddressOffset;
    private boolean codeAddressOffsetValid;
    private boolean compiled;
    HostedMethod[] implementations;
    public final CompilationInfo compilationInfo;
    private final LocalVariableTable localVariableTable;
    private final String name;
    private final String uniqueShortName;

    public static HostedMethod create(HostedUniverse universe, AnalysisMethod wrapped, HostedType holder, Signature signature, ConstantPool constantPool, ExceptionHandler[] handlers, HostedMethod deoptOrigin) {
        LocalVariableTable localVariableTable = HostedMethod.createLocalVariableTable(universe, wrapped);
        Object name = deoptOrigin != null ? wrapped.getName() + METHOD_NAME_DEOPT_SUFFIX : wrapped.getName();
        String uniqueShortName = SubstrateUtil.uniqueShortName(holder.getJavaClass().getClassLoader(), holder, (String)name, signature, wrapped.isConstructor());
        int collisionCount = universe.uniqueHostedMethodNames.merge(uniqueShortName, 0, (oldValue, value) -> oldValue + 1);
        if (collisionCount > 0) {
            name = (String)name + METHOD_NAME_COLLISION_SUFFIX + collisionCount;
            String fixedUniqueShortName = SubstrateUtil.uniqueShortName(holder.getJavaClass().getClassLoader(), holder, (String)name, signature, wrapped.isConstructor());
            VMError.guarantee(!fixedUniqueShortName.equals(uniqueShortName), "failed to generate uniqueShortName for HostedMethod created for " + wrapped);
            uniqueShortName = fixedUniqueShortName;
        }
        return new HostedMethod(wrapped, holder, signature, constantPool, handlers, deoptOrigin, (String)name, uniqueShortName, localVariableTable);
    }

    private static LocalVariableTable createLocalVariableTable(HostedUniverse universe, AnalysisMethod wrapped) {
        LocalVariableTable lvt = wrapped.getLocalVariableTable();
        if (lvt == null) {
            return null;
        }
        try {
            Local[] origLocals = lvt.getLocals();
            Local[] newLocals = new Local[origLocals.length];
            for (int i = 0; i < newLocals.length; ++i) {
                Local origLocal = origLocals[i];
                JavaType origType = origLocal.getType();
                if (!universe.contains(origType)) {
                    throw new UnsupportedFeatureException("No HostedType for given AnalysisType");
                }
                HostedType newType = universe.lookup(origType);
                newLocals[i] = new Local(origLocal.getName(), (JavaType)newType, origLocal.getStartBCI(), origLocal.getEndBCI(), origLocal.getSlot());
            }
            return new LocalVariableTable(newLocals);
        }
        catch (UnsupportedFeatureException e) {
            return null;
        }
    }

    private HostedMethod(AnalysisMethod wrapped, HostedType holder, Signature signature, ConstantPool constantPool, ExceptionHandler[] handlers, HostedMethod deoptOrigin, String name, String uniqueShortName, LocalVariableTable localVariableTable) {
        this.wrapped = wrapped;
        this.holder = holder;
        this.signature = signature;
        this.constantPool = constantPool;
        this.handlers = handlers;
        this.compilationInfo = new CompilationInfo(this, deoptOrigin);
        this.localVariableTable = localVariableTable;
        this.name = name;
        this.uniqueShortName = uniqueShortName;
    }

    public HostedMethod[] getImplementations() {
        return this.implementations;
    }

    public String getQualifiedName() {
        return this.wrapped.getQualifiedName();
    }

    public void setCodeAddressOffset(int address) {
        assert (this.isCompiled());
        assert (!this.codeAddressOffsetValid);
        this.codeAddressOffset = address;
        this.codeAddressOffsetValid = true;
    }

    public int getCodeAddressOffset() {
        if (!this.codeAddressOffsetValid) {
            throw VMError.shouldNotReachHere(this.format("%H.%n(%p)") + ": has no code address offset set.");
        }
        return this.codeAddressOffset;
    }

    public boolean isCodeAddressOffsetValid() {
        return this.codeAddressOffsetValid;
    }

    public void setCompiled() {
        this.compiled = true;
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    public String getUniqueShortName() {
        return this.uniqueShortName;
    }

    public void clear() {
        this.compilationInfo.clear();
        this.staticAnalysisResults = null;
    }

    @Override
    public boolean hasCodeOffsetInImage() {
        throw VMError.unimplemented();
    }

    @Override
    public int getCodeOffsetInImage() {
        throw VMError.unimplemented();
    }

    @Override
    public int getDeoptOffsetInImage() {
        HostedMethod deoptTarget = this.compilationInfo.getDeoptTargetMethod();
        int result = 0;
        if (deoptTarget != null && deoptTarget.isCodeAddressOffsetValid()) {
            result = deoptTarget.getCodeAddressOffset();
            assert (result != 0);
        } else if (this.compilationInfo.isDeoptTarget()) {
            result = this.getCodeAddressOffset();
            assert (result != 0);
        }
        return result;
    }

    public AnalysisMethod getWrapped() {
        return this.wrapped;
    }

    public ResolvedJavaMethod.Parameter[] getParameters() {
        return this.wrapped.getParameters();
    }

    @Override
    public boolean isDeoptTarget() {
        return this.compilationInfo.isDeoptTarget();
    }

    @Override
    public boolean canDeoptimize() {
        return this.compilationInfo.canDeoptForTesting();
    }

    public boolean hasVTableIndex() {
        return this.vtableIndex != -1;
    }

    @Override
    public int getVTableIndex() {
        assert (this.vtableIndex != -1);
        return this.vtableIndex;
    }

    @Override
    public Deoptimizer.StubType getDeoptStubType() {
        Deoptimizer.DeoptStub stubAnnotation = (Deoptimizer.DeoptStub)this.getAnnotation(Deoptimizer.DeoptStub.class);
        if (stubAnnotation != null) {
            return stubAnnotation.stubType();
        }
        return Deoptimizer.StubType.NoDeoptStub;
    }

    @Override
    public boolean isEntryPoint() {
        return this.wrapped.isEntryPoint();
    }

    @Override
    public boolean hasCalleeSavedRegisters() {
        return StubCallingConvention.Utils.hasStubCallingConvention(this);
    }

    public String getName() {
        return this.name;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        return this.wrapped.buildGraph(debug, method, providers, purpose);
    }

    public boolean allowRuntimeCompilation() {
        return this.wrapped.allowRuntimeCompilation();
    }

    public byte[] getCode() {
        return this.wrapped.getCode();
    }

    public int getCodeSize() {
        return this.wrapped.getCodeSize();
    }

    public HostedType getDeclaringClass() {
        return this.holder;
    }

    public int getMaxLocals() {
        return this.wrapped.getMaxLocals();
    }

    public int getMaxStackSize() {
        return this.wrapped.getMaxStackSize();
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public boolean isSynthetic() {
        return this.wrapped.isSynthetic();
    }

    public boolean isVarArgs() {
        return this.wrapped.isVarArgs();
    }

    public boolean isBridge() {
        return this.wrapped.isBridge();
    }

    public boolean isClassInitializer() {
        return this.wrapped.isClassInitializer();
    }

    public boolean isConstructor() {
        return this.wrapped.isConstructor();
    }

    public boolean canBeStaticallyBound() {
        return this.implementations.length == 1 && this.implementations[0].equals(this);
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.handlers;
    }

    public StackTraceElement asStackTraceElement(int bci) {
        return this.wrapped.asStackTraceElement(bci);
    }

    public StaticAnalysisResults getProfilingInfo() {
        return this.staticAnalysisResults;
    }

    public StaticAnalysisResults getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        return this.staticAnalysisResults;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public Annotation[][] getParameterAnnotations() {
        return this.wrapped.getParameterAnnotations();
    }

    public Type[] getGenericParameterTypes() {
        return this.wrapped.getGenericParameterTypes();
    }

    public boolean canBeInlined() {
        return !this.hasNeverInlineDirective();
    }

    public boolean hasNeverInlineDirective() {
        return this.wrapped.hasNeverInlineDirective();
    }

    public boolean shouldBeInlined() {
        return this.getAnnotation(AlwaysInline.class) != null || this.getAnnotation(ForceInline.class) != null;
    }

    public LineNumberTable getLineNumberTable() {
        return this.wrapped.getLineNumberTable();
    }

    public String toString() {
        return "HostedMethod<" + this.format("%h.%n") + " -> " + this.wrapped.toString() + ">";
    }

    public LocalVariableTable getLocalVariableTable() {
        return this.localVariableTable;
    }

    public void reprofile() {
        throw VMError.unimplemented();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        return this.hasVTableIndex();
    }

    public Constant getEncoding() {
        return new SubstrateMethodPointerConstant(new MethodPointer(this));
    }

    public boolean isDefault() {
        throw VMError.unimplemented();
    }

    public SpeculationLog getSpeculationLog() {
        throw VMError.shouldNotReachHere();
    }

    public JavaMethod asJavaMethod() {
        return this;
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public Executable getJavaMethod() {
        return OriginalMethodProvider.getJavaMethod((SnippetReflectionProvider)this.getDeclaringClass().universe.getSnippetReflection(), (ResolvedJavaMethod)this.wrapped);
    }
}

