/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.monitor;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.monitor.MultiThreadedMonitorSupport;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.VMError;
import java.util.Map;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.MembarNode;
import org.graalvm.compiler.nodes.java.AccessMonitorNode;
import org.graalvm.compiler.nodes.java.MonitorEnterNode;
import org.graalvm.compiler.nodes.java.MonitorExitNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public class MonitorSnippets
extends SubstrateTemplates
implements Snippets {
    protected static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_PATH_MONITOR_ENTER = SnippetRuntime.findForeignCall(MultiThreadedMonitorSupport.class, "slowPathMonitorEnter", false, LocationIdentity.any());
    protected static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_PATH_MONITOR_EXIT = SnippetRuntime.findForeignCall(MultiThreadedMonitorSupport.class, "slowPathMonitorExit", false, LocationIdentity.any());
    protected static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{SLOW_PATH_MONITOR_ENTER, SLOW_PATH_MONITOR_EXIT};

    @Snippet
    protected static void monitorEnterSnippet(Object obj) {
        MembarNode.memoryBarrier((MembarNode.FenceKind)MembarNode.FenceKind.NONE, (LocationIdentity)LocationIdentity.any());
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            MonitorSnippets.callSlowPath(SLOW_PATH_MONITOR_ENTER, obj);
        }
    }

    @Snippet
    protected static void monitorExitSnippet(Object obj) {
        MembarNode.memoryBarrier((MembarNode.FenceKind)MembarNode.FenceKind.NONE, (LocationIdentity)LocationIdentity.any());
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            MonitorSnippets.callSlowPath(SLOW_PATH_MONITOR_EXIT, obj);
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    protected static native void callSlowPath(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);

    protected MonitorSnippets(OptionValues options, Providers providers) {
        super(options, providers);
    }

    protected void registerLowerings(Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        MonitorLowering lowering = new MonitorLowering();
        lowerings.put(MonitorEnterNode.class, lowering);
        lowerings.put(MonitorExitNode.class, lowering);
    }

    protected class MonitorLowering
    implements NodeLoweringProvider<AccessMonitorNode> {
        private final SnippetTemplate.SnippetInfo monitorEnter;
        private final SnippetTemplate.SnippetInfo monitorExit;

        protected MonitorLowering() {
            this.monitorEnter = MonitorSnippets.this.snippet(MonitorSnippets.class, "monitorEnterSnippet", new LocationIdentity[0]);
            this.monitorExit = MonitorSnippets.this.snippet(MonitorSnippets.class, "monitorExitSnippet", new LocationIdentity[0]);
        }

        @Override
        public final void lower(AccessMonitorNode node, LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.LOW_TIER) {
                assert (StampTool.isPointerNonNull((ValueNode)node.object())) : "null check is inserted by high-tier lowering";
                this.lowerLowTier(node, tool);
            } else {
                this.lowerHighTier(node, tool);
            }
        }

        protected void lowerHighTier(AccessMonitorNode node, LoweringTool tool) {
            ValueNode object = node.object();
            if (!StampTool.isPointerNonNull((ValueNode)object)) {
                GuardingNode nullCheck = tool.createGuard((FixedNode)node, (LogicNode)node.graph().unique((Node)IsNullNode.create((ValueNode)object)), DeoptimizationReason.NullCheckException, DeoptimizationAction.InvalidateReprofile, SpeculationLog.NO_SPECULATION, true, null);
                node.setObject((ValueNode)node.graph().addOrUnique((Node)PiNode.create((ValueNode)object, (Stamp)StampFactory.objectNonNull(), (ValueNode)((ValueNode)nullCheck))));
            }
        }

        protected void lowerLowTier(AccessMonitorNode node, LoweringTool tool) {
            SnippetTemplate.SnippetInfo snippet;
            if (node instanceof MonitorEnterNode) {
                snippet = this.monitorEnter;
            } else if (node instanceof MonitorExitNode) {
                snippet = this.monitorExit;
            } else {
                throw VMError.shouldNotReachHere();
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("obj", (Object)node.object());
            MonitorSnippets.this.template((ValueNode)node, args).instantiate(MonitorSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

