/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.meta;

import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

public interface ReadableJavaField
extends ResolvedJavaField {
    public static JavaConstant readFieldValue(MetaAccessProvider metaAccess, ConstantReflectionProvider originalConstantReflection, ResolvedJavaField javaField, JavaConstant javaConstant) {
        if (javaField instanceof ReadableJavaField) {
            ReadableJavaField readableField = (ReadableJavaField)javaField;
            if (!1.$assertionsDisabled && !readableField.isValueAvailable()) {
                throw new AssertionError((Object)("Field " + readableField.format("%H.%n") + " value not available for reading."));
            }
            return readableField.readValue(metaAccess, javaConstant);
        }
        return originalConstantReflection.readFieldValue(javaField, javaConstant);
    }

    public JavaConstant readValue(MetaAccessProvider var1, JavaConstant var2);

    default public boolean isValueAvailableBeforeAnalysis() {
        return true;
    }

    default public boolean isValueAvailable() {
        return true;
    }

    public boolean allowConstantFolding();

    public boolean injectFinalForRuntimeCompilation();

    public static boolean injectFinalForRuntimeCompilation(ResolvedJavaField original) {
        if (original instanceof ReadableJavaField) {
            return ((ReadableJavaField)original).injectFinalForRuntimeCompilation();
        }
        return false;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

