/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.struct.PinnedObjectField;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jdk.AbstractUninterruptibleHashtable;
import com.oracle.svm.core.jdk.UninterruptibleEntry;
import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrConstantPool;
import com.oracle.svm.core.jfr.JfrType;
import com.oracle.svm.core.jfr.traceid.JfrTraceIdEpoch;
import com.oracle.svm.core.locks.VMMutex;
import java.nio.charset.StandardCharsets;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;

public class JfrSymbolRepository
implements JfrConstantPool {
    private final VMMutex mutex = new VMMutex("jfrSymbolRepository");
    private final JfrSymbolHashtable table0 = new JfrSymbolHashtable();
    private final JfrSymbolHashtable table1 = new JfrSymbolHashtable();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrSymbolRepository() {
    }

    public void teardown() {
        this.table0.teardown();
        this.table1.teardown();
    }

    @Uninterruptible(reason="Called by uninterruptible code.")
    private JfrSymbolHashtable getTable(boolean previousEpoch) {
        boolean epoch;
        boolean bl = epoch = previousEpoch ? JfrTraceIdEpoch.getInstance().previousEpoch() : JfrTraceIdEpoch.getInstance().currentEpoch();
        if (epoch) {
            return this.table0;
        }
        return this.table1;
    }

    @Uninterruptible(reason="Epoch must not change while in this method.")
    public long getSymbolId(String imageHeapString, boolean previousEpoch) {
        return this.getSymbolId(imageHeapString, previousEpoch, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Epoch must not change while in this method.")
    public long getSymbolId(String imageHeapString, boolean previousEpoch, boolean replaceDotWithSlash) {
        if (imageHeapString == null) {
            return 0L;
        }
        assert (Heap.getHeap().isInImageHeap(imageHeapString));
        JfrSymbol symbol = (JfrSymbol)StackValue.get(JfrSymbol.class);
        symbol.setValue(imageHeapString);
        symbol.setReplaceDotWithSlash(replaceDotWithSlash);
        long rawPointerValue = Word.objectToUntrackedPointer((Object)imageHeapString).rawValue();
        int hashcode = (int)(rawPointerValue ^ rawPointerValue >>> 32);
        symbol.setHash(hashcode);
        this.mutex.lockNoTransition();
        try {
            JfrSymbol entry = this.getTable(previousEpoch).getOrPut(symbol);
            if (entry.isNonNull()) {
                long l = entry.getId();
                return l;
            }
        }
        finally {
            this.mutex.unlock();
        }
        return 0L;
    }

    @Override
    public int write(JfrChunkWriter writer) {
        JfrSymbolHashtable table = this.getTable(true);
        if (table.getSize() == 0) {
            return 0;
        }
        writer.writeCompressedLong(JfrType.Symbol.getId());
        writer.writeCompressedLong(table.getSize());
        JfrSymbol[] entries = table.getTable();
        for (int i = 0; i < entries.length; ++i) {
            JfrSymbol entry = entries[i];
            if (!entry.isNonNull()) continue;
            while (entry.isNonNull()) {
                JfrSymbolRepository.writeSymbol(writer, entry);
                entry = (JfrSymbol)entry.getNext();
            }
        }
        table.clear();
        return 1;
    }

    private static void writeSymbol(JfrChunkWriter writer, JfrSymbol symbol) {
        writer.writeCompressedLong(symbol.getId());
        writer.writeByte(JfrChunkWriter.StringEncoding.UTF8_BYTE_ARRAY.byteValue);
        byte[] value = symbol.getValue().getBytes(StandardCharsets.UTF_8);
        if (symbol.getReplaceDotWithSlash()) {
            JfrSymbolRepository.replaceDotWithSlash(value);
        }
        writer.writeCompressedInt(value.length);
        writer.writeBytes(value);
    }

    private static void replaceDotWithSlash(byte[] utf8String) {
        for (int i = 0; i < utf8String.length; ++i) {
            if (utf8String[i] != 46) continue;
            utf8String[i] = 47;
        }
    }

    private static class JfrSymbolHashtable
    extends AbstractUninterruptibleHashtable {
        private static long nextId;

        private JfrSymbolHashtable() {
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected JfrSymbol[] createTable(int size) {
            return new JfrSymbol[size];
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public JfrSymbol[] getTable() {
            return (JfrSymbol[])super.getTable();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public JfrSymbol getOrPut(UninterruptibleEntry valueOnStack) {
            return (JfrSymbol)super.getOrPut(valueOnStack);
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="image heap pointer comparison")
        protected boolean isEqual(UninterruptibleEntry v0, UninterruptibleEntry v1) {
            JfrSymbol a = (JfrSymbol)v0;
            JfrSymbol b = (JfrSymbol)v1;
            return a.getValue() == b.getValue() && a.getReplaceDotWithSlash() == b.getReplaceDotWithSlash();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected UninterruptibleEntry copyToHeap(UninterruptibleEntry symbolOnStack) {
            JfrSymbol result = (JfrSymbol)this.copyToHeap(symbolOnStack, SizeOf.unsigned(JfrSymbol.class));
            result.setId(++nextId);
            return result;
        }
    }

    @RawStructure
    private static interface JfrSymbol
    extends UninterruptibleEntry {
        @RawField
        public long getId();

        @RawField
        public void setId(long var1);

        @PinnedObjectField
        @RawField
        public String getValue();

        @PinnedObjectField
        @RawField
        public void setValue(String var1);

        @RawField
        public boolean getReplaceDotWithSlash();

        @RawField
        public void setReplaceDotWithSlash(boolean var1);
    }
}

