/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import java.util.Arrays;
import java.util.Comparator;

public class ClassHistogramVisitor
implements ObjectVisitor {
    private final HistogramEntry[] entries = (HistogramEntry[])Heap.getHeap().getLoadedClasses().stream().map(Class::getName).sorted().map(HistogramEntry::new).toArray(HistogramEntry[]::new);

    @Override
    public boolean visitObject(Object o) {
        HistogramEntry entry = this.findEntry(o.getClass().getName());
        if (entry == null) {
            return false;
        }
        ++entry.instanceCount;
        entry.instanceSpace += LayoutEncoding.getSizeFromObject(o).rawValue();
        return true;
    }

    public void prologue() {
        this.reset();
    }

    public void epilogue() {
    }

    private HistogramEntry findEntry(String s) {
        int lo = 0;
        int hi = this.entries.length - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            HistogramEntry entry = this.entries[mid];
            int cmp = entry.className.compareTo(s);
            if (cmp < 0) {
                lo = mid + 1;
                continue;
            }
            if (cmp > 0) {
                hi = mid - 1;
                continue;
            }
            return entry;
        }
        return null;
    }

    public void reset() {
        for (HistogramEntry entry : this.entries) {
            entry.reset();
        }
    }

    public void toLogByName(Log log, long minimum) {
        this.toLogWithComparator(log, minimum, true, Comparator.comparing(e -> e.className));
    }

    public void toLogByCount(Log log, long minimum) {
        this.toLogWithComparator(log, minimum, true, Comparator.comparingLong(e -> e.instanceCount));
    }

    public void toLogBySpace(Log log, long minimum, boolean increasing) {
        this.toLogWithComparator(log, minimum, increasing, Comparator.comparingLong(e -> e.instanceSpace));
    }

    private void toLogWithComparator(Log log, long minimum, boolean increasing, Comparator<HistogramEntry> comparator) {
        Comparator<HistogramEntry> cmp = increasing ? comparator : comparator.reversed();
        HistogramEntry[] filteredArray = (HistogramEntry[])Arrays.stream(this.entries).filter(e -> e.instanceCount >= minimum).sorted(cmp).toArray(HistogramEntry[]::new);
        ClassHistogramVisitor.toLog(log, filteredArray);
    }

    protected static void toLog(Log log, HistogramEntry[] entries) {
        if (entries.length != 0) {
            log.string("  Count\tSize\tName").newline();
        }
        for (HistogramEntry e : entries) {
            ClassHistogramVisitor.toLog(log, e);
        }
    }

    private static void toLog(Log log, HistogramEntry entry) {
        log.string("  ").signed(entry.instanceCount).character('\t').signed(entry.instanceSpace).character('\t').string(entry.className).newline();
    }

    private static class HistogramEntry {
        final String className;
        long instanceCount;
        long instanceSpace;

        HistogramEntry(String className) {
            this.className = className;
            this.reset();
        }

        void reset() {
            this.instanceCount = 0L;
            this.instanceSpace = 0L;
        }
    }
}

