/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.jdk;

import com.oracle.svm.core.graal.jdk.SubstrateObjectCloneNode;
import com.oracle.svm.core.graal.jdk.SubstrateObjectCloneSnippets;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.compiler.replacements.nodes.ObjectClone;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="may be replaced with non-throwing counterpart", size=NodeSize.SIZE_8)
public class SubstrateObjectCloneWithExceptionNode
extends WithExceptionNode
implements ObjectClone,
SingleMemoryKill,
Lowerable {
    public static final NodeClass<SubstrateObjectCloneWithExceptionNode> TYPE = NodeClass.create(SubstrateObjectCloneWithExceptionNode.class);
    public final CallTargetNode.InvokeKind invokeKind;
    public final ResolvedJavaMethod callerMethod;
    public final ResolvedJavaMethod targetMethod;
    public final int bci;
    public final StampPair returnStamp;
    @Node.Input
    protected ValueNode object;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateBefore;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateAfter;

    public SubstrateObjectCloneWithExceptionNode(MacroNode.MacroParams macroParams) {
        super(TYPE, macroParams.returnStamp.getTrustedStamp());
        this.invokeKind = macroParams.invokeKind;
        this.callerMethod = macroParams.callerMethod;
        this.targetMethod = macroParams.targetMethod;
        this.bci = macroParams.bci;
        this.returnStamp = macroParams.returnStamp;
        assert (macroParams.arguments.length == 1);
        this.object = macroParams.arguments[0];
    }

    public CallTargetNode.InvokeKind getInvokeKind() {
        return this.invokeKind;
    }

    public ResolvedJavaMethod getCallerMethod() {
        return this.callerMethod;
    }

    public ResolvedJavaMethod getTargetMethod() {
        return this.targetMethod;
    }

    public int bci() {
        return this.bci;
    }

    public StampPair getReturnStamp() {
        return this.returnStamp;
    }

    public ValueNode getObject() {
        return this.object;
    }

    private MacroNode.MacroParams macroParams() {
        return MacroNode.MacroParams.of((CallTargetNode.InvokeKind)this.invokeKind, (ResolvedJavaMethod)this.callerMethod, (ResolvedJavaMethod)this.targetMethod, (int)this.bci, (StampPair)this.returnStamp, (ValueNode[])new ValueNode[]{this.object});
    }

    public FrameState stateAfter() {
        return this.stateAfter;
    }

    public void setStateAfter(FrameState x) {
        assert (x == null || x.isAlive()) : "frame state must be in a graph";
        this.updateUsages((Node)this.stateAfter, (Node)x);
        this.stateAfter = x;
    }

    public boolean hasSideEffect() {
        return true;
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public FixedNode replaceWithNonThrowing() {
        SubstrateObjectCloneNode plainObjectClone = (SubstrateObjectCloneNode)this.asNode().graph().add((Node)new SubstrateObjectCloneNode(this.macroParams()));
        plainObjectClone.setStateAfter(this.stateAfter());
        AbstractBeginNode oldException = this.exceptionEdge;
        this.graph().replaceSplitWithFixed((ControlSplitNode)this, (FixedWithNextNode)plainObjectClone, this.next());
        GraphUtil.killCFG((FixedNode)oldException);
        return plainObjectClone;
    }

    public void virtualize(VirtualizerTool tool) {
        if (SubstrateObjectCloneSnippets.canVirtualize(this, tool)) {
            super.virtualize(tool);
        }
    }
}

