/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccessExtensionProvider;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.results.AbstractAnalysisResultsBuilder;
import com.oracle.graal.pointsto.results.DefaultResultsBuilder;
import com.oracle.graal.pointsto.results.StaticAnalysisResultsBuilder;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.graal.code.SubstrateMetaAccessExtensionProvider;
import com.oracle.svm.core.monitor.MultiThreadedMonitorSupport;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.SubstrateStrengthenGraphs;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.analysis.flow.SVMMethodTypeFlowBuilder;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.code.SharedRuntimeConfigurationBuilder;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.config.HybridLayoutSupport;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.substitute.UnsafeAutomaticSubstitutionProcessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;

public class HostedConfiguration {
    public static HostedConfiguration instance() {
        return (HostedConfiguration)ImageSingletons.lookup(HostedConfiguration.class);
    }

    public static void setInstanceIfEmpty(HostedConfiguration config) {
        if (!ImageSingletons.contains(HostedConfiguration.class)) {
            ImageSingletons.add(HostedConfiguration.class, (Object)config);
        }
    }

    public static void setDefaultIfEmpty() {
        HostedConfiguration.setInstanceIfEmpty(new HostedConfiguration());
        if (!ImageSingletons.contains(CompressEncoding.class)) {
            CompressEncoding compressEncoding = new CompressEncoding(SubstrateOptions.SpawnIsolates.getValue() != false ? 1L : 0L, 0);
            ImageSingletons.add(CompressEncoding.class, (Object)compressEncoding);
            ObjectLayout objectLayout = HostedConfiguration.createObjectLayout();
            ImageSingletons.add(ObjectLayout.class, (Object)objectLayout);
            ImageSingletons.add(HybridLayoutSupport.class, (Object)new HybridLayoutSupport());
        }
    }

    public static ObjectLayout createObjectLayout() {
        return HostedConfiguration.createObjectLayout(JavaKind.Object);
    }

    public static ObjectLayout createObjectLayout(JavaKind referenceKind) {
        int firstFieldOffset;
        SubstrateTargetDescription target = ConfigurationValues.getTarget();
        int referenceSize = target.arch.getPlatformKind(referenceKind).getSizeInBytes();
        int objectAlignment = 8;
        int hubOffset = 0;
        int identityHashCodeOffset = hubOffset + referenceSize;
        int arrayLengthOffset = firstFieldOffset = identityHashCodeOffset + target.arch.getPlatformKind(JavaKind.Int).getSizeInBytes();
        int arrayBaseOffset = arrayLengthOffset + target.arch.getPlatformKind(JavaKind.Int).getSizeInBytes();
        return new ObjectLayout(target, referenceSize, objectAlignment, hubOffset, firstFieldOffset, arrayLengthOffset, arrayBaseOffset, identityHashCodeOffset);
    }

    public SVMHost createHostVM(OptionValues options, ClassLoader classLoader, ClassInitializationSupport classInitializationSupport, UnsafeAutomaticSubstitutionProcessor automaticSubstitutions, Platform platform, SnippetReflectionProvider originalSnippetReflection) {
        return new SVMHost(options, classLoader, classInitializationSupport, automaticSubstitutions, platform, originalSnippetReflection);
    }

    public CompileQueue createCompileQueue(DebugContext debug, FeatureHandler featureHandler, HostedUniverse hostedUniverse, SharedRuntimeConfigurationBuilder runtime, boolean deoptimizeAll, SnippetReflectionProvider aSnippetReflection, ForkJoinPool executor) {
        return new CompileQueue(debug, featureHandler, hostedUniverse, runtime, deoptimizeAll, aSnippetReflection, executor);
    }

    public MethodTypeFlowBuilder createMethodTypeFlowBuilder(PointsToAnalysis bb, PointsToAnalysisMethod method) {
        return new SVMMethodTypeFlowBuilder(bb, method);
    }

    public MethodTypeFlowBuilder createMethodTypeFlowBuilder(PointsToAnalysis bb, StructuredGraph graph) {
        return new SVMMethodTypeFlowBuilder(bb, graph);
    }

    public MetaAccessExtensionProvider createAnalysisMetaAccessExtensionProvider() {
        return new AnalysisMetaAccessExtensionProvider();
    }

    public MetaAccessExtensionProvider createCompilationMetaAccessExtensionProvider(MetaAccessProvider metaAccess) {
        return new SubstrateMetaAccessExtensionProvider();
    }

    public void findAllFieldsForLayout(HostedUniverse universe, HostedMetaAccess metaAccess, Map<AnalysisField, HostedField> universeFields, ArrayList<HostedField> rawFields, ArrayList<HostedField> orderedFields, HostedInstanceClass clazz) {
        for (AnalysisField aField : clazz.getWrapped().getInstanceFields(false)) {
            HostedField hField = universe.lookup((JavaField)aField);
            if (!hField.getDeclaringClass().equals(clazz)) continue;
            if (HybridLayout.isHybridField(hField)) {
                orderedFields.add(hField);
                continue;
            }
            if (!hField.isAccessed()) continue;
            rawFields.add(hField);
        }
    }

    public AbstractAnalysisResultsBuilder createStaticAnalysisResultsBuilder(Inflation bb, HostedUniverse universe) {
        if (bb instanceof PointsToAnalysis) {
            PointsToAnalysis pta = (PointsToAnalysis)bb;
            if (SubstrateOptions.parseOnce()) {
                return new SubstrateStrengthenGraphs(pta, universe);
            }
            return new StaticAnalysisResultsBuilder(pta, (Universe)universe);
        }
        return new DefaultResultsBuilder((BigBang)bb, (Universe)universe);
    }

    public void collectMonitorFieldInfo(BigBang bb, HostedUniverse hUniverse, Set<AnalysisType> immutableTypes) {
        HostedConfiguration.getForceMonitorSlotTypes(bb).forEach(type -> HostedConfiguration.setMonitorField(hUniverse, type));
        this.processedSynchronizedTypes(bb, hUniverse, immutableTypes);
    }

    private static Set<AnalysisType> getForceMonitorSlotTypes(BigBang bb) {
        HashSet<AnalysisType> forceMonitorTypes = new HashSet<AnalysisType>();
        for (Class<?> forceMonitorType : MultiThreadedMonitorSupport.FORCE_MONITOR_SLOT_TYPES) {
            Optional aType = bb.getMetaAccess().optionalLookupJavaType(forceMonitorType);
            aType.ifPresent(forceMonitorTypes::add);
        }
        return forceMonitorTypes;
    }

    protected void processedSynchronizedTypes(BigBang bb, HostedUniverse hUniverse, Set<AnalysisType> immutableTypes) {
        for (AnalysisType type : bb.getAllSynchronizedTypes()) {
            HostedConfiguration.maybeSetMonitorField(hUniverse, immutableTypes, type);
        }
    }

    protected static void maybeSetMonitorField(HostedUniverse hUniverse, Set<AnalysisType> immutableTypes, AnalysisType type) {
        if (!type.isArray() && !immutableTypes.contains(type)) {
            HostedConfiguration.setMonitorField(hUniverse, type);
        }
    }

    private static void setMonitorField(HostedUniverse hUniverse, AnalysisType type) {
        HostedInstanceClass hostedInstanceClass = (HostedInstanceClass)hUniverse.lookup((JavaType)type);
        hostedInstanceClass.setNeedMonitorField();
    }
}

