/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.OS;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;

public final class ClasspathUtils {
    public static final String cpWildcardSubstitute = "$JavaCla$$pathWildcard$ubstitute$";

    public static Path stringToClasspath(String cp) {
        Object separators = Pattern.quote(File.separator);
        if (OS.getCurrent().equals((Object)OS.WINDOWS)) {
            separators = (String)separators + "/";
        }
        CharSequence[] components = cp.split("[" + (String)separators + "]", Integer.MAX_VALUE);
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].equals("*")) continue;
            components[i] = cpWildcardSubstitute;
        }
        return Paths.get(String.join((CharSequence)File.separator, components), new String[0]);
    }

    public static String classpathToString(Path cp) {
        CharSequence[] components = cp.toString().split(Pattern.quote(File.separator), Integer.MAX_VALUE);
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].equals(cpWildcardSubstitute)) continue;
            components[i] = "*";
        }
        return String.join((CharSequence)File.separator, components);
    }

    public static boolean isJar(Path p) {
        Path fn = p.getFileName();
        assert (fn != null);
        if (Files.exists(p, new LinkOption[0]) && Files.isRegularFile(p, new LinkOption[0]) && Files.isReadable(p)) {
            boolean bl;
            RandomAccessFile file = new RandomAccessFile(p.toFile(), "r");
            try {
                int magic = file.readInt();
                bl = magic == 1347093252 || magic == 1347093766 || magic == 1347094280;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        file.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            file.close();
            return bl;
        }
        return false;
    }
}

