/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.log.Log;
import org.graalvm.word.WordBase;

class HeapChunkLogging {
    private static final int MAX_CHUNKS_TO_PRINT = 65536;

    HeapChunkLogging() {
    }

    public static void logChunks(Log log, AlignedHeapChunk.AlignedHeader firstChunk) {
        if (firstChunk.isNonNull()) {
            int i;
            log.newline().string("aligned chunks:").redent(true);
            AlignedHeapChunk.AlignedHeader chunk = firstChunk;
            for (i = 0; chunk.isNonNull() && i < 65536; ++i) {
                log.newline().zhex((WordBase)chunk).string(" (").zhex((WordBase)AlignedHeapChunk.getObjectsStart(chunk)).string("-").zhex((WordBase)HeapChunk.getTopPointer(chunk)).string(")");
                chunk = HeapChunk.getNext(chunk);
            }
            if (chunk.isNonNull()) {
                assert (i == 65536);
                log.newline().string("... (truncated)");
            }
            log.redent(false);
        }
    }

    public static void logChunks(Log log, UnalignedHeapChunk.UnalignedHeader firstChunk) {
        if (firstChunk.isNonNull()) {
            int i;
            log.newline().string("unaligned chunks:").redent(true);
            UnalignedHeapChunk.UnalignedHeader chunk = firstChunk;
            for (i = 0; chunk.isNonNull() && i < 65536; ++i) {
                log.newline().zhex((WordBase)chunk).string(" (").zhex((WordBase)UnalignedHeapChunk.getObjectStart(chunk)).string("-").zhex((WordBase)HeapChunk.getTopPointer(chunk)).string(")");
                chunk = HeapChunk.getNext(chunk);
            }
            if (chunk.isNonNull()) {
                assert (i == 65536);
                log.newline().string("... (truncated)");
            }
            log.redent(false);
        }
    }
}

