/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.truffle.TruffleBaseFeature;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.truffle.api.staticobject.StaticProperty;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

@TargetClass(className="com.oracle.truffle.api.staticobject.StaticProperty", onlyWith={TruffleBaseFeature.IsEnabled.class})
final class Target_com_oracle_truffle_api_staticobject_StaticProperty {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=OffsetTransformer.class)
    int offset;

    Target_com_oracle_truffle_api_staticobject_StaticProperty() {
    }

    @Alias
    native Class<?> getPropertyType();

    @Alias
    native void initOffset(int var1);

    public static final class OffsetTransformer
    implements FieldValueTransformer {
        private static final Method GET_PROPERTY_TYPE = ReflectionUtil.lookupMethod(StaticProperty.class, (String)"getPropertyType", (Class[])new Class[0]);

        public Object transform(Object receiver, Object originalValue) {
            int indexScale;
            int baseOffset;
            JavaKind javaKind;
            Class propertyType;
            int offset = (Integer)originalValue;
            if (offset == 0) {
                return offset;
            }
            StaticProperty receiverStaticProperty = (StaticProperty)receiver;
            try {
                propertyType = (Class)GET_PROPERTY_TYPE.invoke((Object)receiverStaticProperty, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw VMError.shouldNotReachHere(e);
            }
            if (propertyType.isPrimitive()) {
                javaKind = JavaKind.Byte;
                baseOffset = Unsafe.ARRAY_BYTE_BASE_OFFSET;
                indexScale = Unsafe.ARRAY_BYTE_INDEX_SCALE;
            } else {
                javaKind = JavaKind.Object;
                baseOffset = Unsafe.ARRAY_OBJECT_BASE_OFFSET;
                indexScale = Unsafe.ARRAY_OBJECT_INDEX_SCALE;
            }
            assert (offset >= baseOffset && (offset - baseOffset) % indexScale == 0);
            int index = (offset - baseOffset) / indexScale;
            int svmArrayBaseOffset = ConfigurationValues.getObjectLayout().getArrayBaseOffset(javaKind);
            int svmArrayIndexScaleOffset = ConfigurationValues.getObjectLayout().getArrayIndexScale(javaKind);
            return svmArrayBaseOffset + svmArrayIndexScaleOffset * index;
        }
    }
}

