/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.cenum;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.cenum.CEnumCallWrapperMethod;
import com.oracle.svm.util.GuardedAnnotationAccess;
import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.c.constant.CEnumLookup;
import org.graalvm.nativeimage.c.constant.CEnumValue;

public class CEnumCallWrapperSubstitutionProcessor
extends SubstitutionProcessor {
    private final Map<ResolvedJavaMethod, CEnumCallWrapperMethod> callWrappers = new ConcurrentHashMap<ResolvedJavaMethod, CEnumCallWrapperMethod>();
    private NativeLibraries nativeLibraries;

    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        if (GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)method, CEnumLookup.class) || GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)method, CEnumValue.class)) {
            return this.callWrappers.computeIfAbsent(method, v -> new CEnumCallWrapperMethod(this.nativeLibraries, (ResolvedJavaMethod)v));
        }
        return method;
    }

    public ResolvedJavaMethod resolve(ResolvedJavaMethod method) {
        if (method instanceof CEnumCallWrapperMethod) {
            return ((CEnumCallWrapperMethod)method).getOriginal();
        }
        return method;
    }

    public void setNativeLibraries(NativeLibraries nativeLibs) {
        this.nativeLibraries = nativeLibs;
    }
}

