/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.info;

import com.oracle.graal.pointsto.infrastructure.WrappedElement;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaType;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.c.CTypedef;
import com.oracle.svm.core.c.struct.PinnedObjectField;
import com.oracle.svm.hosted.c.BuiltinDirectives;
import com.oracle.svm.hosted.c.NativeCodeContext;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.AccessorInfo;
import com.oracle.svm.hosted.c.info.ConstantInfo;
import com.oracle.svm.hosted.c.info.EnumConstantInfo;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.c.info.EnumLookupInfo;
import com.oracle.svm.hosted.c.info.EnumValueInfo;
import com.oracle.svm.hosted.c.info.NativeCodeInfo;
import com.oracle.svm.hosted.c.info.PointerToInfo;
import com.oracle.svm.hosted.c.info.RawPointerToInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import com.oracle.svm.hosted.c.info.StructBitfieldInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import com.oracle.svm.hosted.cenum.CEnumCallWrapperMethod;
import com.oracle.svm.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.bytecode.BridgeMethodUtils;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumConstant;
import org.graalvm.nativeimage.c.constant.CEnumLookup;
import org.graalvm.nativeimage.c.constant.CEnumValue;
import org.graalvm.nativeimage.c.struct.CBitfield;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CFieldAddress;
import org.graalvm.nativeimage.c.struct.CFieldOffset;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawFieldAddress;
import org.graalvm.nativeimage.c.struct.RawFieldOffset;
import org.graalvm.nativeimage.c.struct.RawPointerTo;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.UniqueLocationIdentity;
import org.graalvm.word.PointerBase;

public class InfoTreeBuilder {
    private final Providers originalProviders;
    private final NativeLibraries nativeLibs;
    private final NativeCodeContext codeCtx;
    private final NativeCodeInfo nativeCodeInfo;

    public InfoTreeBuilder(NativeLibraries nativeLibs, NativeCodeContext codeCtx) {
        String name;
        this.nativeLibs = nativeLibs;
        this.codeCtx = codeCtx;
        boolean isBuiltin = codeCtx.getDirectives() instanceof BuiltinDirectives;
        if (codeCtx.getDirectives() != null) {
            name = ClassUtil.getUnqualifiedName(codeCtx.getDirectives().getClass());
        } else {
            StringBuilder nameBuilder = new StringBuilder();
            String sep = "";
            for (String headerFile : codeCtx.getDirectives().getHeaderFiles()) {
                nameBuilder.append(sep).append(headerFile);
                sep = "_";
            }
            name = nameBuilder.toString();
        }
        this.nativeCodeInfo = new NativeCodeInfo(name, codeCtx.getDirectives(), isBuiltin);
        this.originalProviders = GraalAccess.getOriginalProviders();
    }

    public NativeCodeInfo construct() {
        for (ResolvedJavaMethod method : this.codeCtx.getConstantAccessors()) {
            this.createConstantInfo(method);
        }
        for (ResolvedJavaType type : this.codeCtx.getStructTypes()) {
            this.createStructInfo(type);
        }
        for (ResolvedJavaType type : this.codeCtx.getRawStructTypes()) {
            this.createRawStructInfo(type);
        }
        for (ResolvedJavaType type : this.codeCtx.getCPointerToTypes()) {
            this.createCPointerToInfo(type);
        }
        for (ResolvedJavaType type : this.codeCtx.getRawPointerToTypes()) {
            this.createRawPointerToInfo(type);
        }
        for (ResolvedJavaType type : this.codeCtx.getEnumTypes()) {
            this.createEnumInfo(type);
        }
        return this.nativeCodeInfo;
    }

    private MetaAccessProvider getMetaAccess() {
        return this.nativeLibs.getMetaAccess();
    }

    protected void createConstantInfo(ResolvedJavaMethod method) {
        int actualParamCount = InfoTreeBuilder.getParameterCount(method);
        if (actualParamCount != 0) {
            this.nativeLibs.addError("Wrong number of parameters: expected 0; found " + actualParamCount, method);
            return;
        }
        ResolvedJavaType returnType = AccessorInfo.getReturnType(method);
        if (returnType.getJavaKind() == JavaKind.Void || returnType.getJavaKind() == JavaKind.Object && !this.nativeLibs.isString(returnType) && !this.nativeLibs.isByteArray(returnType) && !this.nativeLibs.isWordBase(returnType)) {
            this.nativeLibs.addError("Wrong return type: expected a primitive type, String, or a Word type; found " + returnType.toJavaName(true), method);
            return;
        }
        String constantName = InfoTreeBuilder.getConstantName(method);
        SizableInfo.ElementKind elementKind = this.elementKind(returnType, false);
        ConstantInfo constantInfo = new ConstantInfo(constantName, elementKind, method);
        this.nativeCodeInfo.adoptChild(constantInfo);
        this.nativeLibs.registerElementInfo((AnnotatedElement)method, constantInfo);
    }

    private void createCPointerToInfo(ResolvedJavaType type) {
        if (!this.validInterfaceDefinition(type, CPointerTo.class)) {
            return;
        }
        ArrayList<AccessorInfo> accessorInfos = new ArrayList<AccessorInfo>();
        ResolvedJavaMethod[] resolvedJavaMethodArray = type.getDeclaredMethods();
        int n = resolvedJavaMethodArray.length;
        for (int i = 0; i < n; ++i) {
            boolean isIndexed;
            ResolvedJavaMethod method;
            AccessorInfo.AccessorKind accessorKind = InfoTreeBuilder.returnsDeclaringClass(method = resolvedJavaMethodArray[i]) ? AccessorInfo.AccessorKind.ADDRESS : InfoTreeBuilder.getAccessorKind(method);
            AccessorInfo accessorInfo = new AccessorInfo(method, accessorKind, isIndexed = InfoTreeBuilder.getParameterCount(method) > (accessorKind == AccessorInfo.AccessorKind.SETTER ? 1 : 0), false, false);
            if (!this.accessorValid(accessorInfo)) continue;
            accessorInfos.add(accessorInfo);
            this.nativeLibs.registerElementInfo((AnnotatedElement)method, accessorInfo);
        }
        String typeName = this.getCPointerToTypeName(type);
        String typedefName = InfoTreeBuilder.getTypedefName(type);
        PointerToInfo pointerToInfo = new PointerToInfo(typeName, typedefName, this.elementKind(accessorInfos), type);
        pointerToInfo.adoptChildren(accessorInfos);
        this.nativeCodeInfo.adoptChild(pointerToInfo);
        this.nativeLibs.registerElementInfo((AnnotatedElement)type, pointerToInfo);
    }

    private void createRawPointerToInfo(ResolvedJavaType type) {
        if (!this.validInterfaceDefinition(type, RawPointerTo.class)) {
            return;
        }
        ArrayList<AccessorInfo> accessorInfos = new ArrayList<AccessorInfo>();
        ResolvedJavaMethod[] resolvedJavaMethodArray = type.getDeclaredMethods();
        int n = resolvedJavaMethodArray.length;
        for (int i = 0; i < n; ++i) {
            boolean isIndexed;
            ResolvedJavaMethod method;
            AccessorInfo.AccessorKind accessorKind = InfoTreeBuilder.returnsDeclaringClass(method = resolvedJavaMethodArray[i]) ? AccessorInfo.AccessorKind.ADDRESS : InfoTreeBuilder.getAccessorKind(method);
            AccessorInfo accessorInfo = new AccessorInfo(method, accessorKind, isIndexed = InfoTreeBuilder.getParameterCount(method) > (accessorKind == AccessorInfo.AccessorKind.SETTER ? 1 : 0), false, false);
            if (!this.accessorValid(accessorInfo)) continue;
            accessorInfos.add(accessorInfo);
            this.nativeLibs.registerElementInfo((AnnotatedElement)method, accessorInfo);
        }
        String typeName = this.getRawPointerToTypeName(type);
        RawPointerToInfo pointerToInfo = new RawPointerToInfo(typeName, this.elementKind(accessorInfos), type);
        pointerToInfo.adoptChildren(accessorInfos);
        this.nativeCodeInfo.adoptChild(pointerToInfo);
        this.nativeLibs.registerElementInfo((AnnotatedElement)type, pointerToInfo);
    }

    private static int getParameterCount(ResolvedJavaMethod method) {
        return method.getSignature().getParameterCount(false);
    }

    private static boolean returnsDeclaringClass(ResolvedJavaMethod accessor) {
        return AccessorInfo.getReturnType(accessor).equals(accessor.getDeclaringClass());
    }

    private static AccessorInfo.AccessorKind getAccessorKind(ResolvedJavaMethod accessor) {
        return accessor.getSignature().getReturnKind() == JavaKind.Void ? AccessorInfo.AccessorKind.SETTER : AccessorInfo.AccessorKind.GETTER;
    }

    public static String getTypedefName(ResolvedJavaType type) {
        CTypedef typedefAnnotation = (CTypedef)type.getAnnotation(CTypedef.class);
        return typedefAnnotation != null ? typedefAnnotation.name() : null;
    }

    private void createStructInfo(ResolvedJavaType type) {
        if (!this.validInterfaceDefinition(type, CStruct.class)) {
            return;
        }
        TreeMap fieldAccessorInfos = new TreeMap();
        TreeMap<String, ArrayList<AccessorInfo>> bitfieldAccessorInfos = new TreeMap<String, ArrayList<AccessorInfo>>();
        ArrayList<AccessorInfo> structAccessorInfos = new ArrayList<AccessorInfo>();
        for (ResolvedJavaMethod method : type.getDeclaredMethods()) {
            String fieldName;
            AccessorInfo accessorInfo;
            CField fieldAnnotation = InfoTreeBuilder.getMethodAnnotation(method, CField.class);
            CFieldAddress fieldAddressAnnotation = InfoTreeBuilder.getMethodAnnotation(method, CFieldAddress.class);
            CFieldOffset fieldOffsetAnnotation = InfoTreeBuilder.getMethodAnnotation(method, CFieldOffset.class);
            CBitfield bitfieldAnnotation = InfoTreeBuilder.getMethodAnnotation(method, CBitfield.class);
            if (fieldAnnotation != null) {
                accessorInfo = new AccessorInfo(method, InfoTreeBuilder.getAccessorKind(method), false, this.hasLocationIdentityParameter(method), InfoTreeBuilder.hasUniqueLocationIdentity(method));
                fieldName = InfoTreeBuilder.getStructFieldName(accessorInfo, fieldAnnotation.value());
            } else if (bitfieldAnnotation != null) {
                accessorInfo = new AccessorInfo(method, InfoTreeBuilder.getAccessorKind(method), false, this.hasLocationIdentityParameter(method), false);
                fieldName = InfoTreeBuilder.getStructFieldName(accessorInfo, bitfieldAnnotation.value());
            } else if (fieldAddressAnnotation != null) {
                accessorInfo = new AccessorInfo(method, AccessorInfo.AccessorKind.ADDRESS, false, false, false);
                fieldName = InfoTreeBuilder.getStructFieldName(accessorInfo, fieldAddressAnnotation.value());
            } else if (fieldOffsetAnnotation != null) {
                accessorInfo = new AccessorInfo(method, AccessorInfo.AccessorKind.OFFSET, false, false, false);
                fieldName = InfoTreeBuilder.getStructFieldName(accessorInfo, fieldOffsetAnnotation.value());
            } else if (InfoTreeBuilder.returnsDeclaringClass(method)) {
                accessorInfo = new AccessorInfo(method, AccessorInfo.AccessorKind.ADDRESS, InfoTreeBuilder.getParameterCount(method) > 0, false, false);
                fieldName = null;
            } else {
                this.nativeLibs.addError("Unexpected method without annotation", method);
                continue;
            }
            if (!this.accessorValid(accessorInfo)) continue;
            if (fieldName == null) {
                structAccessorInfos.add(accessorInfo);
            } else {
                TreeMap<String, ArrayList<AccessorInfo>> map = bitfieldAnnotation != null ? bitfieldAccessorInfos : fieldAccessorInfos;
                ArrayList<AccessorInfo> accessorInfos = (ArrayList<AccessorInfo>)map.get(fieldName);
                if (accessorInfos == null) {
                    accessorInfos = new ArrayList<AccessorInfo>();
                    map.put(fieldName, accessorInfos);
                }
                accessorInfos.add(accessorInfo);
            }
            this.nativeLibs.registerElementInfo((AnnotatedElement)method, accessorInfo);
        }
        StructInfo structInfo = StructInfo.create(InfoTreeBuilder.getStructName(type), type);
        structInfo.adoptChildren(structAccessorInfos);
        for (Map.Entry entry : fieldAccessorInfos.entrySet()) {
            StructFieldInfo fieldInfo = new StructFieldInfo((String)entry.getKey(), this.elementKind((Collection)entry.getValue()));
            fieldInfo.adoptChildren((Collection)entry.getValue());
            structInfo.adoptChild(fieldInfo);
        }
        for (Map.Entry entry : bitfieldAccessorInfos.entrySet()) {
            if (fieldAccessorInfos.containsKey(entry.getKey())) {
                this.nativeLibs.addError("Bitfield and regular field accessor methods cannot be mixed", entry.getValue(), fieldAccessorInfos.get(entry.getKey()));
            } else if (this.elementKind((Collection)entry.getValue()) != SizableInfo.ElementKind.INTEGER) {
                this.nativeLibs.addError("Bitfield accessor method must have integer kind", entry.getValue());
            }
            StructBitfieldInfo bitfieldInfo = new StructBitfieldInfo((String)entry.getKey());
            bitfieldInfo.adoptChildren((Collection)entry.getValue());
            structInfo.adoptChild(bitfieldInfo);
        }
        this.nativeCodeInfo.adoptChild(structInfo);
        this.nativeLibs.registerElementInfo((AnnotatedElement)type, structInfo);
    }

    private void createRawStructInfo(ResolvedJavaType type) {
        if (!this.validInterfaceDefinition(type, RawStructure.class)) {
            return;
        }
        TreeMap<String, ArrayList<AccessorInfo>> fieldAccessorInfos = new TreeMap<String, ArrayList<AccessorInfo>>();
        ArrayList<AccessorInfo> structAccessorInfos = new ArrayList<AccessorInfo>();
        for (ResolvedJavaMethod method : type.getDeclaredMethods()) {
            String fieldName;
            AccessorInfo accessorInfo;
            RawField fieldAnnotation = InfoTreeBuilder.getMethodAnnotation(method, RawField.class);
            RawFieldAddress fieldAddressAnnotation = InfoTreeBuilder.getMethodAnnotation(method, RawFieldAddress.class);
            RawFieldOffset fieldOffsetAnnotation = InfoTreeBuilder.getMethodAnnotation(method, RawFieldOffset.class);
            if (fieldAnnotation != null) {
                accessorInfo = new AccessorInfo(method, InfoTreeBuilder.getAccessorKind(method), false, this.hasLocationIdentityParameter(method), InfoTreeBuilder.hasUniqueLocationIdentity(method));
                fieldName = InfoTreeBuilder.getStructFieldName(accessorInfo, "");
            } else if (fieldAddressAnnotation != null) {
                accessorInfo = new AccessorInfo(method, AccessorInfo.AccessorKind.ADDRESS, false, false, false);
                fieldName = InfoTreeBuilder.getStructFieldName(accessorInfo, "");
            } else if (fieldOffsetAnnotation != null) {
                accessorInfo = new AccessorInfo(method, AccessorInfo.AccessorKind.OFFSET, false, false, false);
                fieldName = InfoTreeBuilder.getStructFieldName(accessorInfo, "");
            } else if (InfoTreeBuilder.returnsDeclaringClass(method)) {
                accessorInfo = new AccessorInfo(method, AccessorInfo.AccessorKind.ADDRESS, InfoTreeBuilder.getParameterCount(method) > 0, false, false);
                fieldName = null;
            } else {
                this.nativeLibs.addError("Unexpected method without annotation", method);
                continue;
            }
            if (!this.accessorValid(accessorInfo)) continue;
            if (fieldName == null) {
                structAccessorInfos.add(accessorInfo);
            } else {
                TreeMap<String, ArrayList<AccessorInfo>> map = fieldAccessorInfos;
                ArrayList<AccessorInfo> accessorInfos = (ArrayList<AccessorInfo>)map.get(fieldName);
                if (accessorInfos == null) {
                    accessorInfos = new ArrayList<AccessorInfo>();
                    map.put(fieldName, accessorInfos);
                }
                accessorInfos.add(accessorInfo);
            }
            this.nativeLibs.registerElementInfo((AnnotatedElement)method, accessorInfo);
        }
        StructInfo structInfo = StructInfo.create(InfoTreeBuilder.getStructName(type), type);
        structInfo.adoptChildren(structAccessorInfos);
        for (Map.Entry entry : fieldAccessorInfos.entrySet()) {
            StructFieldInfo fieldInfo = new StructFieldInfo((String)entry.getKey(), this.elementKind((Collection)entry.getValue()));
            fieldInfo.adoptChildren((Collection)entry.getValue());
            structInfo.adoptChild(fieldInfo);
        }
        this.nativeCodeInfo.adoptChild(structInfo);
        this.nativeLibs.registerElementInfo((AnnotatedElement)type, structInfo);
    }

    private boolean hasLocationIdentityParameter(ResolvedJavaMethod method) {
        int parameterCount = InfoTreeBuilder.getParameterCount(method);
        if (parameterCount == 0) {
            return false;
        }
        ResolvedJavaType lastParam = AccessorInfo.getParameterType(method, parameterCount - 1);
        return this.nativeLibs.getLocationIdentityType().equals(lastParam);
    }

    private static boolean hasUniqueLocationIdentity(ResolvedJavaMethod method) {
        return InfoTreeBuilder.getMethodAnnotation(method, UniqueLocationIdentity.class) != null;
    }

    private SizableInfo.ElementKind elementKind(Collection<AccessorInfo> accessorInfos) {
        SizableInfo.ElementKind overallKind = SizableInfo.ElementKind.UNKNOWN;
        AccessorInfo overallKindAccessor = null;
        block4: for (AccessorInfo accessorInfo : accessorInfos) {
            ResolvedJavaType type;
            switch (accessorInfo.getAccessorKind()) {
                case GETTER: {
                    type = accessorInfo.getReturnType();
                    break;
                }
                case SETTER: {
                    type = accessorInfo.getValueParameterType();
                    break;
                }
                default: {
                    continue block4;
                }
            }
            ResolvedJavaMethod method = accessorInfo.getAnnotatedElement();
            SizableInfo.ElementKind newKind = this.elementKind(type, InfoTreeBuilder.isPinnedObjectFieldAccessor(method));
            if (overallKind == SizableInfo.ElementKind.UNKNOWN) {
                overallKind = newKind;
                overallKindAccessor = accessorInfo;
                continue;
            }
            if (overallKind == newKind) continue;
            this.nativeLibs.addError("Accessor methods mix integer, floating point, and pointer kinds", overallKindAccessor.getAnnotatedElement(), method);
        }
        return overallKind;
    }

    private SizableInfo.ElementKind elementKind(ResolvedJavaType type, boolean isPinnedObject) {
        switch (type.getJavaKind()) {
            case Boolean: 
            case Byte: 
            case Char: 
            case Short: 
            case Int: 
            case Long: {
                return SizableInfo.ElementKind.INTEGER;
            }
            case Float: 
            case Double: {
                return SizableInfo.ElementKind.FLOAT;
            }
            case Object: {
                if (this.nativeLibs.isSigned(type) || this.nativeLibs.isUnsigned(type)) {
                    return SizableInfo.ElementKind.INTEGER;
                }
                if (isPinnedObject) {
                    return SizableInfo.ElementKind.OBJECT;
                }
                if (this.nativeLibs.isString(type)) {
                    return SizableInfo.ElementKind.STRING;
                }
                if (this.nativeLibs.isByteArray(type)) {
                    return SizableInfo.ElementKind.BYTEARRAY;
                }
                return SizableInfo.ElementKind.POINTER;
            }
        }
        return SizableInfo.ElementKind.UNKNOWN;
    }

    private static boolean isPinnedObjectFieldAccessor(ResolvedJavaMethod method) {
        return InfoTreeBuilder.getMethodAnnotation(method, PinnedObjectField.class) != null;
    }

    private boolean accessorValid(AccessorInfo accessorInfo) {
        ResolvedJavaType returnType;
        ResolvedJavaType paramType;
        ResolvedJavaMethod method = accessorInfo.getAnnotatedElement();
        int expectedParamCount = accessorInfo.parameterCount(false);
        int actualParamCount = InfoTreeBuilder.getParameterCount(method);
        if (actualParamCount != expectedParamCount) {
            this.nativeLibs.addError("Wrong number of parameters: expected " + expectedParamCount + "; found " + actualParamCount, method);
            return false;
        }
        if (accessorInfo.isIndexed() && (paramType = accessorInfo.getParameterType(accessorInfo.indexParameterNumber(false))).getJavaKind() != JavaKind.Int && paramType.getJavaKind() != JavaKind.Long && !this.nativeLibs.isSigned(paramType)) {
            this.nativeLibs.addError("Wrong type of index parameter 0: expected int, long, or Signed; found " + paramType.toJavaName(true), method);
            return false;
        }
        if (accessorInfo.hasLocationIdentityParameter() && accessorInfo.hasUniqueLocationIdentity()) {
            this.nativeLibs.addError("Method cannot have annotation @" + UniqueLocationIdentity.class.getSimpleName() + " and a LocationIdentity parameter", method);
            return false;
        }
        if (accessorInfo.hasLocationIdentityParameter()) {
            paramType = accessorInfo.getParameterType(accessorInfo.locationIdentityParameterNumber(false));
            if (!this.nativeLibs.getLocationIdentityType().equals(paramType)) {
                this.nativeLibs.addError("Wrong type of locationIdentity parameter: expected " + this.nativeLibs.getLocationIdentityType().toJavaName(true) + "; found " + paramType.toJavaName(true), method);
                return false;
            }
        }
        if (!this.checkObjectType(returnType = AccessorInfo.getReturnType(method), method)) {
            return false;
        }
        switch (accessorInfo.getAccessorKind()) {
            case ADDRESS: {
                if (this.nativeLibs.isPointerBase(returnType) && !this.nativeLibs.isSigned(returnType) && !this.nativeLibs.isUnsigned(returnType)) break;
                this.nativeLibs.addError("Wrong return type: expected a pointer type; found " + returnType.toJavaName(true), method);
                return false;
            }
            case OFFSET: {
                if (returnType.getJavaKind().isNumericInteger() || this.nativeLibs.isUnsigned(returnType)) break;
                this.nativeLibs.addError("Wrong return type: expected an integer numeric type or Unsigned; found " + returnType.toJavaName(true), method);
                return false;
            }
            case SETTER: {
                if (this.checkObjectType(accessorInfo.getValueParameterType(), method)) break;
                return false;
            }
        }
        return true;
    }

    private boolean checkObjectType(ResolvedJavaType returnType, ResolvedJavaMethod method) {
        if (returnType.getJavaKind() == JavaKind.Object && !this.nativeLibs.isWordBase(returnType) && !InfoTreeBuilder.isPinnedObjectFieldAccessor(method)) {
            this.nativeLibs.addError("Wrong type: expected a primitive type or a Word type; found " + returnType.toJavaName(true) + ". Use the annotation @" + PinnedObjectField.class.getSimpleName() + " if you know what you are doing.", method);
            return false;
        }
        return true;
    }

    private boolean validInterfaceDefinition(ResolvedJavaType type, Class<? extends Annotation> annotationClass) {
        assert (type.getAnnotation(annotationClass) != null);
        if (!type.isInterface() || !this.nativeLibs.isPointerBase(type)) {
            this.nativeLibs.addError("Annotation @" + ClassUtil.getUnqualifiedName(annotationClass) + " can only be used on an interface that extends " + PointerBase.class.getSimpleName(), type);
            return false;
        }
        return true;
    }

    private static String removePrefix(String name, String prefix) {
        assert (prefix.length() > 0);
        String result = name;
        if (result.startsWith(prefix) && (result = result.substring(prefix.length())).startsWith("_")) {
            result = result.substring("_".length());
        }
        return result;
    }

    private static String getConstantName(ResolvedJavaMethod method) {
        CConstant constantAnnotation = InfoTreeBuilder.getMethodAnnotation(method, CConstant.class);
        String name = constantAnnotation.value();
        if (name.length() == 0) {
            name = method.getName();
            name = InfoTreeBuilder.removePrefix(name, "get");
        }
        return name;
    }

    private String getCPointerToTypeName(ResolvedJavaType type) {
        CPointerTo pointerToCPointerAnnotation;
        CStruct pointerToCStructAnnotation;
        CPointerTo pointerToAnnotation = (CPointerTo)type.getAnnotation(CPointerTo.class);
        Class pointerToType = pointerToAnnotation.value();
        String nameOfCType = pointerToAnnotation.nameOfCType();
        do {
            pointerToCStructAnnotation = pointerToType.getAnnotation(CStruct.class);
            pointerToCPointerAnnotation = pointerToType.getAnnotation(CPointerTo.class);
        } while (pointerToCStructAnnotation == null && pointerToCPointerAnnotation == null && (pointerToType = pointerToType.getInterfaces().length == 1 ? pointerToType.getInterfaces()[0] : null) != null);
        int n = (nameOfCType.length() > 0 ? 1 : 0) + (pointerToCStructAnnotation != null ? 1 : 0) + (pointerToCPointerAnnotation != null ? 1 : 0);
        if (n != 1) {
            this.nativeLibs.addError("Exactly one of 1) literal C type name, 2) class annotated with @" + CStruct.class.getSimpleName() + ", or 3) class annotated with @" + CPointerTo.class.getSimpleName() + " must be specified in @" + CPointerTo.class.getSimpleName() + " annotation", type);
            return "__error";
        }
        if (pointerToCStructAnnotation != null) {
            return InfoTreeBuilder.getStructName(this.getMetaAccess().lookupJavaType(pointerToType)) + "*";
        }
        if (pointerToCPointerAnnotation != null) {
            return this.getCPointerToTypeName(this.getMetaAccess().lookupJavaType(pointerToType)) + "*";
        }
        return nameOfCType;
    }

    private String getRawPointerToTypeName(ResolvedJavaType type) {
        RawPointerTo pointerToRawPointerAnnotation;
        RawStructure pointerToRawStructAnnotation;
        RawPointerTo pointerToAnnotation = (RawPointerTo)type.getAnnotation(RawPointerTo.class);
        Class pointerToType = pointerToAnnotation.value();
        do {
            pointerToRawStructAnnotation = pointerToType.getAnnotation(RawStructure.class);
            pointerToRawPointerAnnotation = pointerToType.getAnnotation(RawPointerTo.class);
        } while (pointerToRawStructAnnotation == null && pointerToRawPointerAnnotation == null && (pointerToType = pointerToType.getInterfaces().length == 1 ? pointerToType.getInterfaces()[0] : null) != null);
        int n = (pointerToRawStructAnnotation != null ? 1 : 0) + (pointerToRawPointerAnnotation != null ? 1 : 0);
        if (n != 1) {
            this.nativeLibs.addError("Exactly one of 1) class annotated with @" + RawStructure.class.getSimpleName() + ", or 2) class annotated with @" + RawPointerTo.class.getSimpleName() + " must be specified in @" + RawPointerTo.class.getSimpleName() + " annotation", type);
            return "__error";
        }
        if (pointerToRawStructAnnotation != null) {
            return InfoTreeBuilder.getStructName(this.getMetaAccess().lookupJavaType(pointerToType)) + "*";
        }
        assert (pointerToRawPointerAnnotation != null);
        return this.getRawPointerToTypeName(this.getMetaAccess().lookupJavaType(pointerToType)) + "*";
    }

    private static String getStructName(ResolvedJavaType type) {
        CStruct structAnnotation = (CStruct)type.getAnnotation(CStruct.class);
        if (structAnnotation == null) {
            RawStructure rsanno = (RawStructure)type.getAnnotation(RawStructure.class);
            assert (rsanno != null) : "Unexpected struct type " + type;
            return InfoTreeBuilder.getSimpleJavaName(type);
        }
        Object name = structAnnotation.value();
        if (((String)name).length() == 0) {
            name = InfoTreeBuilder.getSimpleJavaName(type);
        }
        if (structAnnotation.addStructKeyword()) {
            name = "struct " + (String)name;
        }
        return name;
    }

    private static String getSimpleJavaName(ResolvedJavaType type) {
        String name = type.toJavaName(false);
        int innerClassSeparator = name.lastIndexOf(36);
        if (innerClassSeparator >= 0) {
            name = name.substring(innerClassSeparator + 1);
        }
        return name;
    }

    private static String getStructFieldName(AccessorInfo info, String annotationValue) {
        if (annotationValue.length() != 0) {
            return annotationValue;
        }
        return InfoTreeBuilder.removePrefix(info.getAnnotatedElement().getName(), info.getAccessorPrefix());
    }

    private void createEnumInfo(ResolvedJavaType type) {
        if (!this.nativeLibs.isEnum(type)) {
            this.nativeLibs.addError("Annotation @" + CEnum.class.getSimpleName() + " can only be used on an Java enumeration", type);
            return;
        }
        CEnum annotation = (CEnum)type.getAnnotation(CEnum.class);
        Object name = annotation.value();
        if (!((String)name).isEmpty()) {
            if (annotation.addEnumKeyword()) {
                name = "enum " + (String)name;
            }
        } else {
            name = "int";
        }
        EnumInfo enumInfo = new EnumInfo((String)name, type);
        ResolvedJavaType wrappedType = ((WrappedJavaType)type).getWrapped();
        for (ResolvedJavaField resolvedJavaField : wrappedType.getStaticFields()) {
            assert (Modifier.isStatic(resolvedJavaField.getModifiers()));
            if (!Modifier.isFinal(resolvedJavaField.getModifiers()) || !resolvedJavaField.getType().equals(wrappedType)) continue;
            this.createEnumConstantInfo(enumInfo, resolvedJavaField);
        }
        for (ResolvedJavaField resolvedJavaField : type.getDeclaredMethods()) {
            if (InfoTreeBuilder.getMethodAnnotation((ResolvedJavaMethod)resolvedJavaField, CEnumValue.class) != null) {
                this.createEnumValueInfo(enumInfo, (ResolvedJavaMethod)resolvedJavaField);
            }
            if (InfoTreeBuilder.getMethodAnnotation((ResolvedJavaMethod)resolvedJavaField, CEnumLookup.class) == null) continue;
            this.createEnumLookupInfo(enumInfo, (ResolvedJavaMethod)resolvedJavaField);
        }
        this.nativeCodeInfo.adoptChild(enumInfo);
        this.nativeLibs.registerElementInfo((AnnotatedElement)type, enumInfo);
    }

    private void createEnumConstantInfo(EnumInfo enumInfo, ResolvedJavaField field) {
        JavaConstant enumValue = this.originalProviders.getConstantReflection().readFieldValue(field, null);
        ResolvedJavaType originalType = this.originalProviders.getMetaAccess().lookupJavaType(enumValue);
        assert (enumValue.isNonNull() && originalType.equals(((WrappedElement)enumInfo.getAnnotatedElement()).getWrapped()));
        CEnumConstant fieldAnnotation = (CEnumConstant)field.getAnnotation(CEnumConstant.class);
        String name = "";
        boolean includeInLookup = true;
        if (fieldAnnotation != null) {
            name = fieldAnnotation.value();
            includeInLookup = fieldAnnotation.includeInLookup();
        }
        if (name.length() == 0) {
            name = field.getName();
        }
        Enum value = (Enum)this.originalProviders.getSnippetReflection().asObject(Enum.class, enumValue);
        EnumConstantInfo constantInfo = new EnumConstantInfo(name, field, includeInLookup, value);
        enumInfo.adoptChild(constantInfo);
    }

    private static ResolvedJavaMethod originalMethod(ResolvedJavaMethod method) {
        assert (method instanceof AnalysisMethod);
        AnalysisMethod analysisMethod = (AnalysisMethod)method;
        assert (analysisMethod.getWrapped() instanceof CEnumCallWrapperMethod);
        CEnumCallWrapperMethod wrapperMethod = (CEnumCallWrapperMethod)analysisMethod.getWrapped();
        return wrapperMethod.getOriginal();
    }

    private void createEnumValueInfo(EnumInfo enumInfo, ResolvedJavaMethod method) {
        ResolvedJavaMethod originalMethod = InfoTreeBuilder.originalMethod(method);
        if (!Modifier.isNative(originalMethod.getModifiers()) || Modifier.isStatic(originalMethod.getModifiers())) {
            this.nativeLibs.addError("Method annotated with @" + CEnumValue.class.getSimpleName() + " must be a non-static native method", method);
            return;
        }
        if (InfoTreeBuilder.getParameterCount(method) != 0) {
            this.nativeLibs.addError("Method annotated with @" + CEnumValue.class.getSimpleName() + " cannot have parameters", method);
            return;
        }
        SizableInfo.ElementKind elementKind = this.elementKind(AccessorInfo.getReturnType(method), false);
        if (elementKind != SizableInfo.ElementKind.INTEGER) {
            this.nativeLibs.addError("Method annotated with @" + CEnumValue.class.getSimpleName() + " must have an integer return type", method);
            return;
        }
        EnumValueInfo valueInfo = new EnumValueInfo(method);
        enumInfo.adoptChild(valueInfo);
        this.nativeLibs.registerElementInfo((AnnotatedElement)method, valueInfo);
    }

    private void createEnumLookupInfo(EnumInfo enumInfo, ResolvedJavaMethod method) {
        ResolvedJavaMethod originalMethod = InfoTreeBuilder.originalMethod(method);
        if (!Modifier.isNative(originalMethod.getModifiers()) || !Modifier.isStatic(originalMethod.getModifiers())) {
            this.nativeLibs.addError("Method annotated with @" + CEnumLookup.class.getSimpleName() + " must be a static native method", method);
            return;
        }
        if (InfoTreeBuilder.getParameterCount(method) != 1 || this.elementKind(AccessorInfo.getParameterType(method, 0), false) != SizableInfo.ElementKind.INTEGER) {
            this.nativeLibs.addError("Method annotated with @" + CEnumLookup.class.getSimpleName() + " must have exactly one integer parameter", method);
            return;
        }
        if (!InfoTreeBuilder.returnsDeclaringClass(method)) {
            this.nativeLibs.addError("Return type of method annotated with @" + CEnumLookup.class.getSimpleName() + " must be the annotation type", method);
            return;
        }
        enumInfo.needsLookup = true;
        EnumLookupInfo lookupInfo = new EnumLookupInfo(method);
        enumInfo.adoptChild(lookupInfo);
        this.nativeLibs.registerElementInfo((AnnotatedElement)method, lookupInfo);
    }

    private static <T extends Annotation> T getMethodAnnotation(ResolvedJavaMethod method, Class<T> annotationClass) {
        return (T)BridgeMethodUtils.getAnnotation(annotationClass, (ResolvedJavaMethod)method);
    }
}

