/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.headers.linux.LinuxPthread;
import com.oracle.svm.core.posix.headers.linux.LinuxTime;
import com.oracle.svm.core.thread.ThreadCpuTimeSupport;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CIntPointer;

@AutomaticallyRegisteredImageSingleton(value={ThreadCpuTimeSupport.class})
final class LinuxThreadCpuTimeSupport
implements ThreadCpuTimeSupport {
    LinuxThreadCpuTimeSupport() {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getCurrentThreadCpuTime(boolean includeSystemTime) {
        if (!includeSystemTime) {
            return -1L;
        }
        return LinuxThreadCpuTimeSupport.getThreadCpuTimeImpl(LinuxTime.CLOCK_THREAD_CPUTIME_ID());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getThreadCpuTime(VMThreads.OSThreadHandle osThreadHandle, boolean includeSystemTime) {
        if (!includeSystemTime) {
            return -1L;
        }
        CIntPointer threadsClockId = (CIntPointer)StackValue.get((int)4);
        if (LinuxPthread.pthread_getcpuclockid((Pthread.pthread_t)osThreadHandle, threadsClockId) != 0) {
            return -1L;
        }
        return LinuxThreadCpuTimeSupport.getThreadCpuTimeImpl(threadsClockId.read());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static long getThreadCpuTimeImpl(int clockId) {
        Time.timespec time = (Time.timespec)StackValue.get(Time.timespec.class);
        if (LinuxTime.clock_gettime(clockId, time) != 0) {
            return -1L;
        }
        return time.tv_sec() * 1000000000L + time.tv_nsec();
    }
}

