/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.darwin.DarwinPthread;
import com.oracle.svm.core.posix.headers.darwin.DarwinVirtualMemory;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={StackOverflowCheck.OSSupport.class})
class DarwinStackOverflowSupport
implements StackOverflowCheck.OSSupport {
    DarwinStackOverflowSupport() {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord lookupStackBase() {
        Pthread.pthread_t self = Pthread.pthread_self();
        return DarwinPthread.pthread_get_stackaddr_np(self);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord lookupStackEnd() {
        return this.lookupStackEnd((UnsignedWord)WordFactory.zero());
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    private static boolean isProtected(int prot) {
        return (prot & (DarwinVirtualMemory.VM_PROT_READ() | DarwinVirtualMemory.VM_PROT_WRITE())) == 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    private static int vmComputeStackGuard(UnsignedWord stackend) {
        int guardsize = 0;
        WordPointer address = (WordPointer)StackValue.get(WordPointer.class);
        address.write((WordBase)stackend);
        WordPointer size = (WordPointer)StackValue.get(WordPointer.class);
        size.write(WordFactory.zero());
        DarwinVirtualMemory.vm_region_basic_info_data_64_t info = (DarwinVirtualMemory.vm_region_basic_info_data_64_t)StackValue.get(DarwinVirtualMemory.vm_region_basic_info_data_64_t.class);
        WordPointer task = DarwinVirtualMemory.mach_task_self();
        do {
            WordPointer dummyobject = (WordPointer)StackValue.get(WordPointer.class);
            CIntPointer count = (CIntPointer)StackValue.get(CIntPointer.class);
            count.write(DarwinVirtualMemory.VM_REGION_SUBMAP_INFO_COUNT_64());
            if (DarwinVirtualMemory.mach_vm_region(task, address, size, DarwinVirtualMemory.VM_REGION_BASIC_INFO_64(), info, count, dummyobject) != 0) {
                return -1;
            }
            if (DarwinStackOverflowSupport.isProtected(info.protection())) {
                guardsize = (int)((long)guardsize + size.read().rawValue());
            }
            UnsignedWord currentAddress = (UnsignedWord)address.read();
            address.write((WordBase)currentAddress.add((UnsignedWord)size.read()));
        } while (DarwinStackOverflowSupport.isProtected(info.protection()));
        return guardsize;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord lookupStackEnd(UnsignedWord requestedStackSize) {
        UnsignedWord stacksize;
        Pthread.pthread_t self = Pthread.pthread_self();
        Pointer stackaddr = DarwinPthread.pthread_get_stackaddr_np(self);
        int guardsize = DarwinStackOverflowSupport.vmComputeStackGuard(stackaddr.subtract(stacksize = DarwinPthread.pthread_get_stacksize_np(self)));
        VMError.guarantee(guardsize >= 0 && guardsize < 102400);
        VMError.guarantee(stacksize.aboveThan(guardsize));
        stacksize = stacksize.subtract(guardsize);
        if (requestedStackSize.notEqual((UnsignedWord)WordFactory.zero()) && stacksize.aboveThan(requestedStackSize)) {
            return stackaddr.subtract(requestedStackSize);
        }
        return stackaddr.subtract(stacksize);
    }
}

