/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferType;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class JfrBufferAccess {
    private static final int ACQUIRED = 1;
    private static final int NOT_ACQUIRED = 0;

    private JfrBufferAccess() {
    }

    @Fold
    public static UnsignedWord getHeaderSize() {
        return UnsignedUtils.roundUp(SizeOf.unsigned(JfrBuffer.class), WordFactory.unsigned((int)ConfigurationValues.getTarget().wordSize));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JfrBuffer allocate(UnsignedWord dataSize, JfrBufferType bufferType) {
        UnsignedWord headerSize = JfrBufferAccess.getHeaderSize();
        JfrBuffer result = (JfrBuffer)((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).malloc(headerSize.add(dataSize));
        if (result.isNonNull()) {
            result.setSize(dataSize);
            result.setBufferType(bufferType);
            JfrBufferAccess.reinitialize(result);
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void free(JfrBuffer buffer) {
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)buffer);
    }

    @Uninterruptible(reason="Prevent safepoints as those could change the top pointer.")
    public static void reinitialize(JfrBuffer buffer) {
        Pointer pos = JfrBufferAccess.getDataStart(buffer);
        buffer.setPos(pos);
        buffer.setTop(pos);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isAcquired(JfrBuffer buffer) {
        return buffer.getAcquired() == 1;
    }

    @Uninterruptible(reason="We must guarantee that all buffers are in unacquired state when entering a safepoint.", callerMustBe=true)
    public static boolean acquire(JfrBuffer buffer) {
        return ((Pointer)buffer).logicCompareAndSwapInt(JfrBuffer.offsetOfAcquired(), 0, 1, NamedLocationIdentity.OFF_HEAP_LOCATION);
    }

    @Uninterruptible(reason="We must guarantee that all buffers are in unacquired state when entering a safepoint.", callerMustBe=true)
    public static void release(JfrBuffer buffer) {
        assert (buffer.getAcquired() == 1);
        buffer.setAcquired(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getAddressOfPos(JfrBuffer buffer) {
        return ((Pointer)buffer).add(JfrBuffer.offsetOfPos());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getDataStart(JfrBuffer buffer) {
        return ((Pointer)buffer).add(JfrBufferAccess.getHeaderSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getDataEnd(JfrBuffer buffer) {
        return JfrBufferAccess.getDataStart(buffer).add(buffer.getSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getAvailableSize(JfrBuffer buffer) {
        return JfrBufferAccess.getDataEnd(buffer).subtract((UnsignedWord)buffer.getPos());
    }

    @Uninterruptible(reason="Prevent safepoints as those could change the top pointer.", callerMustBe=true)
    public static UnsignedWord getUnflushedSize(JfrBuffer buffer) {
        return buffer.getPos().subtract((UnsignedWord)buffer.getTop());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void increasePos(JfrBuffer buffer, UnsignedWord delta) {
        buffer.setPos(buffer.getPos().add(delta));
    }

    @Uninterruptible(reason="Prevent safepoints as those could change the top pointer.")
    public static void increaseTop(JfrBuffer buffer, UnsignedWord delta) {
        buffer.setTop(buffer.getTop().add(delta));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isEmpty(JfrBuffer buffer) {
        return JfrBufferAccess.getDataStart(buffer).equal((UnsignedWord)buffer.getPos());
    }
}

