/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.JavaMemoryUtil;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.nodes.NewPodInstanceNode;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class PodReferenceMapDecoder {
    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    public static boolean walkOffsetsFromPointer(Pointer baseAddress, int layoutEncoding, ObjectReferenceVisitor visitor, Object obj) {
        int nrefs;
        int gap;
        int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        boolean isCompressed = ReferenceAccess.singleton().haveCompressedReferences();
        UnsignedWord refOffset = LayoutEncoding.getArrayBaseOffset(layoutEncoding);
        UnsignedWord mapOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, ArrayLengthNode.arrayLength((Object)obj));
        do {
            mapOffset = mapOffset.subtract(2);
            gap = Byte.toUnsignedInt(baseAddress.readByte((WordBase)mapOffset));
            nrefs = Byte.toUnsignedInt(baseAddress.readByte((WordBase)mapOffset.add(1)));
            for (int i = 0; i < nrefs; ++i) {
                if (!visitor.visitObjectReferenceInline(baseAddress.add(refOffset), 0, isCompressed, obj)) {
                    return false;
                }
                refOffset = refOffset.add(referenceSize);
            }
            refOffset = refOffset.add(referenceSize * gap);
        } while (gap != 0 || nrefs == 255);
        return true;
    }

    public static Object clone(Object original, DynamicHub hub, int layoutEncoding) {
        Class nonNullHub = (Class)GraalDirectives.guardingNonNull(DynamicHub.toClass(hub));
        int length = ArrayLengthNode.arrayLength((Object)original);
        byte[] referenceMap = PodReferenceMapDecoder.extractReferenceMap(original, layoutEncoding, length);
        Object result = NewPodInstanceNode.newPodInstance(null, nonNullHub, length, referenceMap);
        PodReferenceMapDecoder.copyArray(original, result, layoutEncoding, length);
        return result;
    }

    private static byte[] extractReferenceMap(Object obj, int layoutEncoding, int length) {
        int nrefs;
        int gap;
        UnsignedWord mapEndOffset;
        UnsignedWord mapOffset = mapEndOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, length);
        do {
            mapOffset = mapOffset.subtract(2);
            gap = Byte.toUnsignedInt(BarrieredAccess.readByte((Object)obj, (WordBase)mapOffset));
            nrefs = Byte.toUnsignedInt(BarrieredAccess.readByte((Object)obj, (WordBase)mapOffset.add(1)));
        } while (gap != 0 || nrefs == 255);
        int refMapLength = UnsignedUtils.safeToInt(mapEndOffset.subtract(mapOffset));
        byte[] refMap = new byte[refMapLength];
        for (int i = 0; i < refMapLength; ++i) {
            refMap[i] = BarrieredAccess.readByte((Object)obj, (WordBase)mapOffset.add(i));
        }
        return refMap;
    }

    private static void copyArray(Object original, Object copy, int layoutEncoding, int length) {
        UnsignedWord nrefs;
        UnsignedWord gap;
        int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        UnsignedWord refOffset = LayoutEncoding.getArrayBaseOffset(layoutEncoding);
        UnsignedWord mapOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, length);
        do {
            mapOffset = mapOffset.subtract(2);
            gap = WordFactory.unsigned((int)Byte.toUnsignedInt(BarrieredAccess.readByte((Object)copy, (WordBase)mapOffset)));
            nrefs = WordFactory.unsigned((int)Byte.toUnsignedInt(BarrieredAccess.readByte((Object)copy, (WordBase)mapOffset.add(1))));
            JavaMemoryUtil.copyReferencesForward(original, refOffset, copy, refOffset, nrefs);
            UnsignedWord primOffset = refOffset.add(nrefs.multiply(referenceSize));
            UnsignedWord primBytes = gap.multiply(referenceSize);
            JavaMemoryUtil.copyForward(original, primOffset, copy, primOffset, primBytes);
            refOffset = primOffset.add(primBytes);
        } while (gap.notEqual(0) || nrefs.equal(255));
        UnsignedWord primBytes = mapOffset.subtract(refOffset);
        JavaMemoryUtil.copyForward(original, refOffset, copy, refOffset, primBytes);
    }

    private PodReferenceMapDecoder() {
    }
}

