/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.config;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.util.GuardedAnnotationAccess;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.word.WordBase;

public final class ObjectLayout {
    private final SubstrateTargetDescription target;
    private final int referenceSize;
    private final int objectAlignment;
    private final int alignmentMask;
    private final int hubOffset;
    private final int firstFieldOffset;
    private final int arrayLengthOffset;
    private final int arrayBaseOffset;
    private final int identityHashCodeOffset;

    public ObjectLayout(SubstrateTargetDescription target, int referenceSize, int objectAlignment, int hubOffset, int firstFieldOffset, int arrayLengthOffset, int arrayBaseOffset, int identityHashCodeOffset) {
        assert (CodeUtil.isPowerOf2((int)referenceSize));
        assert (CodeUtil.isPowerOf2((int)objectAlignment));
        assert (hubOffset < firstFieldOffset && hubOffset < arrayLengthOffset);
        assert (identityHashCodeOffset > 0 && identityHashCodeOffset < arrayLengthOffset);
        this.target = target;
        this.referenceSize = referenceSize;
        this.objectAlignment = objectAlignment;
        this.alignmentMask = objectAlignment - 1;
        this.hubOffset = hubOffset;
        this.firstFieldOffset = firstFieldOffset;
        this.arrayLengthOffset = arrayLengthOffset;
        this.arrayBaseOffset = arrayBaseOffset;
        this.identityHashCodeOffset = identityHashCodeOffset;
    }

    public int getAlignment() {
        return this.objectAlignment;
    }

    public boolean isAligned(long value) {
        return value % (long)this.getAlignment() == 0L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getReferenceSize() {
        return this.referenceSize;
    }

    public int getDeoptScratchSpace() {
        return this.target.getDeoptScratchSpace();
    }

    public int sizeInBytes(JavaKind kind) {
        return kind == JavaKind.Object ? this.referenceSize : this.target.arch.getPlatformKind(kind).getSizeInBytes();
    }

    public int getArrayIndexShift(JavaKind kind) {
        return CodeUtil.log2((int)this.getArrayIndexScale(kind));
    }

    public int getArrayIndexScale(JavaKind kind) {
        return this.sizeInBytes(kind);
    }

    public int alignUp(int obj) {
        return obj + this.alignmentMask & ~this.alignmentMask;
    }

    public long alignUp(long obj) {
        return obj + (long)this.alignmentMask & (long)(~this.alignmentMask);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getHubOffset() {
        return this.hubOffset;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getFirstFieldOffset() {
        return this.firstFieldOffset;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getArrayLengthOffset() {
        return this.arrayLengthOffset;
    }

    @Fold
    public int getIdentityHashCodeOffset() {
        return this.identityHashCodeOffset;
    }

    public int getArrayBaseOffset(JavaKind kind) {
        return NumUtil.roundUp((int)this.arrayBaseOffset, (int)this.sizeInBytes(kind));
    }

    public long getArrayElementOffset(JavaKind kind, int index) {
        return this.getArrayBaseOffset(kind) + index * this.sizeInBytes(kind);
    }

    public long getArraySize(JavaKind kind, int length) {
        assert (length >= 0);
        return this.alignUp((long)this.getArrayBaseOffset(kind) + ((long)length << this.getArrayIndexShift(kind)));
    }

    public int getMinimumInstanceObjectSize() {
        return this.alignUp(this.firstFieldOffset);
    }

    public int getMinimumArraySize() {
        return NumUtil.safeToInt((long)this.getArraySize(JavaKind.Byte, 0));
    }

    public int getMinimumObjectSize() {
        return Math.min(this.getMinimumArraySize(), this.getMinimumInstanceObjectSize());
    }

    public static JavaKind getCallSignatureKind(boolean isEntryPoint, ResolvedJavaType type, MetaAccessProvider metaAccess, TargetDescription target) {
        if (metaAccess.lookupJavaType(WordBase.class).isAssignableFrom(type)) {
            return target.wordJavaKind;
        }
        if (isEntryPoint && GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)type, CEnum.class)) {
            return JavaKind.Int;
        }
        return type.getJavaKind();
    }
}

