/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.InterruptImageBuilding;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.nativeimage.Platform;

public final class VMInspectionOptions {
    private static final String ENABLE_MONITORING_OPTION = "enable-monitoring";
    private static final String MONITORING_ALL_NAME = "all";
    private static final String MONITORING_HEAPDUMP_NAME = "heapdump";
    private static final String MONITORING_JFR_NAME = "jfr";
    private static final String MONITORING_JVMSTAT_NAME = "jvmstat";
    private static final String MONITORING_ALLOWED_VALUES = "'heapdump', 'jfr', 'jvmstat', or 'all' (defaults to 'all' if no argument is provided)";
    @APIOption(name={"enable-monitoring"}, defaultValue={"all"})
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> EnableMonitoringFeatures = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings(), VMInspectionOptions::validateEnableMonitoringFeatures);
    public static final HostedOptionKey<Boolean> DumpRuntimeCompilationOnSignal = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> DumpThreadStacksOnSignal = new HostedOptionKey<Boolean>(false);

    public static void validateEnableMonitoringFeatures(OptionKey<?> optionKey) {
        Set<String> enabledFeatures = VMInspectionOptions.getEnabledMonitoringFeatures();
        enabledFeatures.removeAll(List.of(MONITORING_HEAPDUMP_NAME, MONITORING_JFR_NAME, MONITORING_JVMSTAT_NAME, MONITORING_ALL_NAME));
        if (!enabledFeatures.isEmpty()) {
            throw new InterruptImageBuilding("The option " + optionKey.getName() + " contains invalid value(s): " + String.join((CharSequence)", ", enabledFeatures) + ". It can only contain 'heapdump', 'jfr', 'jvmstat', or 'all' (defaults to 'all' if no argument is provided).");
        }
    }

    @Fold
    public static String getHeapdumpsCommandArgument() {
        return SubstrateOptionsParser.commandArgument(EnableMonitoringFeatures, MONITORING_HEAPDUMP_NAME);
    }

    public static Set<String> getEnabledMonitoringFeatures() {
        return new HashSet<String>(OptionUtils.flatten(",", EnableMonitoringFeatures.getValue()));
    }

    private static boolean hasAllOrKeywordMonitoringSupport(String keyword) {
        Set<String> enabledFeatures = VMInspectionOptions.getEnabledMonitoringFeatures();
        return enabledFeatures.contains(MONITORING_ALL_NAME) || enabledFeatures.contains(keyword);
    }

    @Fold
    public static boolean hasHeapDumpSupport() {
        return VMInspectionOptions.hasAllOrKeywordMonitoringSupport(MONITORING_HEAPDUMP_NAME) && !Platform.includedIn(Platform.WINDOWS.class);
    }

    @Fold
    public static boolean hasJFRSupport() {
        return VMInspectionOptions.hasAllOrKeywordMonitoringSupport(MONITORING_JFR_NAME) && !Platform.includedIn(Platform.WINDOWS.class);
    }

    @Fold
    public static boolean hasJvmstatSupport() {
        return VMInspectionOptions.hasAllOrKeywordMonitoringSupport(MONITORING_JVMSTAT_NAME) && !Platform.includedIn(Platform.WINDOWS.class);
    }

    private VMInspectionOptions() {
    }

    static class DeprecatedOptions {
        static final HostedOptionKey<Boolean> AllowVMInspection = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
                EnableMonitoringFeatures.update(values, newValue != false ? VMInspectionOptions.MONITORING_ALL_NAME : "");
                DumpRuntimeCompilationOnSignal.update(values, true);
                super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
            }
        };

        DeprecatedOptions() {
        }
    }
}

